<?php
/**
 * Create Missing Tenant Folders
 * Creates folder structure for existing schools that don't have them
 * 
 * Run this ONCE to fix existing schools
 * New schools will auto-create folders
 */

require_once __DIR__ . '/../includes/functions.php';
require_once __DIR__ . '/../includes/tenant_directory_manager.php';

echo "=====================================\n";
echo "  CREATE MISSING TENANT FOLDERS\n";
echo "=====================================\n\n";

$pdo = getDB();
$tenantManager = new TenantDirectoryManager($pdo);

// Get all schools from database
$stmt = $pdo->query("
    SELECT reference_code, academy_name, created_at 
    FROM academy_references 
    ORDER BY created_at
");
$schools = $stmt->fetchAll();

echo "Found " . count($schools) . " schools in database\n\n";

$created = 0;
$existing = 0;
$errors = 0;

foreach ($schools as $school) {
    $code = $school['reference_code'];
    $name = $school['academy_name'];
    
    echo "Processing: $name ($code)... ";
    
    $result = $tenantManager->initializeTenant($code, $name);
    
    if ($result['success']) {
        if (isset($result['already_exists']) && $result['already_exists']) {
            echo "✓ Already exists\n";
            $existing++;
        } else {
            echo "✓ CREATED!\n";
            echo "  Path: " . $result['path'] . "\n";
            $created++;
        }
    } else {
        echo "✗ ERROR: " . $result['message'] . "\n";
        $errors++;
    }
}

echo "\n=====================================\n";
echo "  SUMMARY\n";
echo "=====================================\n";
echo "Total Schools:    " . count($schools) . "\n";
echo "Created Folders:  $created\n";
echo "Already Existed:  $existing\n";
echo "Errors:           $errors\n";
echo "=====================================\n";

if ($created > 0) {
    echo "\n✅ Successfully created folders for $created school(s)!\n";
    echo "Folder location: Multi-Tanent/tenants/{SCHOOL_CODE}/\n\n";
}

if ($errors > 0) {
    echo "\n⚠️  $errors error(s) occurred. Check logs for details.\n\n";
}

echo "DONE!\n";

