<?php
/**
 * Script to change subject price across the system
 */

require_once __DIR__ . '/../config.php';

echo "💰 Subject Price Configuration\n";
echo "==============================\n\n";

echo "Current subject price: SZL " . SUBJECT_PRICE . "\n\n";

echo "To change the subject price:\n";
echo "1. Edit config.php\n";
echo "2. Change the SUBJECT_PRICE constant\n";
echo "3. Run this script to verify the change\n\n";

echo "Example:\n";
echo "// In config.php, change this line:\n";
echo "define('SUBJECT_PRICE', 0.50); // Change from 0.30 to 0.50\n\n";

echo "Files that use SUBJECT_PRICE:\n";
echo "✅ admin/update_status.php - Manual payment status updates\n";
echo "✅ cron/daily_payment_check.php - Daily payment calculations\n";
echo "✅ tools/update_monthly_payment_schema.php - Database schema updates\n\n";

echo "After changing the price in config.php:\n";
echo "1. The system will automatically use the new price\n";
echo "2. New payments will use the updated price\n";
echo "3. Existing payment cycles will keep their original amounts\n";
echo "4. Email templates will show the new price\n\n";

echo "Current configuration:\n";
echo "📊 Subject Price: SZL " . SUBJECT_PRICE . "\n";
echo "📊 Max Students: " . MAX_STUDENTS . "\n";
echo "📊 App Name: " . APP_NAME . "\n";
?>
