<?php
/**
 * Student Payment Success
 * Shows payment confirmation
 */

session_start();
require_once '../includes/functions.php';
requireStudentLogin();

if (!isset($_SESSION['payment_success'])) {
    header('Location: dashboard.php');
    exit;
}

$payment_info = $_SESSION['payment_success'];
unset($_SESSION['payment_success']);

$student = getCurrentStudent();
$pdo = getDB();

// Get school settings
$stmt = $pdo->prepare("SELECT setting_value FROM tenant_settings WHERE academy_reference = ? AND setting_key = 'currency_symbol'");
$stmt->execute([$student['academy_reference']]);
$currency_symbol = $stmt->fetchColumn() ?: 'E';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Payment Successful - Student Portal</title>
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
        }
        .success-icon {
            font-size: 5rem;
            color: #10b981;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-md-6">
                <div class="card shadow-lg">
                    <div class="card-body text-center py-5">
                        <i class="bi bi-check-circle-fill success-icon mb-4 d-block"></i>
                        <h2 class="text-success mb-3">Payment Successful!</h2>
                        <p class="lead">Your payment has been processed successfully.</p>
                        
                        <div class="alert alert-success text-start mt-4">
                            <div class="mb-2">
                                <strong>Payment Reference:</strong><br>
                                <code class="fs-5"><?= htmlspecialchars($payment_info['reference']) ?></code>
                            </div>
                            <div class="mb-2">
                                <strong>Amount Paid:</strong><br>
                                <span class="h5"><?= $currency_symbol ?><?= number_format($payment_info['amount'], 2) ?></span>
                            </div>
                            <div>
                                <strong>Subjects:</strong><br>
                                <?= $payment_info['subjects'] ?> subject(s) enrolled
                            </div>
                        </div>

                        <div class="alert alert-info text-start">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Next Steps:</strong>
                            <ul class="mb-0 mt-2">
                                <li>You have been enrolled in your selected subjects</li>
                                <li>You can now access course materials</li>
                                <li>Login to Moodle with the same credentials</li>
                                <li>Check your email for payment receipt</li>
                            </ul>
                        </div>

                        <div class="d-grid gap-2 mt-4">
                            <a href="dashboard.php" class="btn btn-primary btn-lg">
                                <i class="bi bi-house me-2"></i>Go to Dashboard
                            </a>
                            <a href="subjects.php" class="btn btn-outline-primary">
                                <i class="bi bi-book me-2"></i>View My Subjects
                            </a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

