<?php
/**
 * Email Templates for Skolo-Kine Learning Platform
 */

// Email verification template
function getEmailVerificationTemplate($student_name, $verification_link) {
    return "
    <!DOCTYPE html>
    <html lang='en'>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <title>Verify Your Email - " . APP_NAME . "</title>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #6f42c1, #20c997); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 10px 10px; }
            .button { display: inline-block; background: #6f42c1; color: white; padding: 15px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }
            .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>🎓 Welcome to " . APP_NAME . "</h1>
                <p>Verify Your Email Address</p>
            </div>
            <div class='content'>
                <h2>Hello " . htmlspecialchars($student_name) . "!</h2>
                <p>Thank you for registering with " . APP_NAME . ". To complete your registration and access your learning materials, please verify your email address.</p>
                
                <p><strong>Click the button below to verify your email:</strong></p>
                <a href='" . $verification_link . "' class='button'>Verify Email Address</a>
                
                <p>If the button doesn't work, copy and paste this link into your browser:</p>
                <p style='word-break: break-all; background: #e9ecef; padding: 10px; border-radius: 5px;'>" . $verification_link . "</p>
                
                <p><strong>Important:</strong></p>
                <ul>
                    <li>This link will expire in 24 hours</li>
                    <li>You must verify your email to access your courses</li>
                    <li>If you didn't register for this account, please ignore this email</li>
                </ul>
                
                <p>Once verified, you'll be able to:</p>
                <ul>
                    <li>Access your personalized learning dashboard</li>
                    <li>View your enrolled subjects and materials</li>
                    <li>Track your learning progress</li>
                    <li>Communicate with your teachers</li>
                </ul>
            </div>
            <div class='footer'>
                <p>This email was sent by " . APP_NAME . " Learning Platform</p>
                <p>If you have any questions, please contact our support team</p>
            </div>
        </div>
    </body>
    </html>
    ";
}

// Welcome email template
function getWelcomeEmailTemplate($student_name, $login_url, $subjects) {
    $subjects_list = '';
    foreach ($subjects as $subject) {
        $subjects_list .= "<li>" . htmlspecialchars($subject['name']) . "</li>";
    }
    
    return "
    <!DOCTYPE html>
    <html lang='en'>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <title>Welcome to " . APP_NAME . "</title>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #6f42c1, #20c997); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 10px 10px; }
            .button { display: inline-block; background: #20c997; color: white; padding: 15px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }
            .subjects { background: #e9ecef; padding: 15px; border-radius: 5px; margin: 20px 0; }
            .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>🎉 Welcome to " . APP_NAME . "!</h1>
                <p>Your account is now active</p>
            </div>
            <div class='content'>
                <h2>Hello " . htmlspecialchars($student_name) . "!</h2>
                <p>Congratulations! Your email has been verified and your account is now active. You can now access your personalized learning dashboard.</p>
                
                <a href='" . $login_url . "' class='button'>Access Your Dashboard</a>
                
                <div class='subjects'>
                    <h3>📚 Your Enrolled Subjects:</h3>
                    <ul>" . $subjects_list . "</ul>
                </div>
                
                <h3>🚀 What's Next?</h3>
                <ol>
                    <li><strong>Login to your account</strong> using your email and password</li>
                    <li><strong>Explore your subjects</strong> and access learning materials</li>
                    <li><strong>Join our WhatsApp group</strong> for updates and support</li>
                    <li><strong>Start learning</strong> and track your progress</li>
                </ol>
                
                <h3>📱 Stay Connected</h3>
                <p>Join our WhatsApp group for:</p>
                <ul>
                    <li>📢 Important announcements</li>
                    <li>💬 Peer discussions</li>
                    <li>❓ Quick support</li>
                    <li>🎯 Study tips and resources</li>
                </ul>
                
                <p><a href='" . WHATSAPP_GROUP_LINK . "' target='_blank' style='color: #25D366; text-decoration: none;'>📱 Join WhatsApp Group</a></p>
            </div>
            <div class='footer'>
                <p>Happy Learning! 🎓</p>
                <p>This email was sent by " . APP_NAME . " Learning Platform</p>
            </div>
        </div>
    </body>
    </html>
    ";
}

// Payment confirmation template
function getPaymentConfirmationTemplate($student_name, $amount, $subjects) {
    $subjects_list = '';
    foreach ($subjects as $subject) {
        $subjects_list .= "<li>" . htmlspecialchars($subject['name']) . " - " . SUBJECT_PRICE_SZL . " SZL</li>";
    }
    
    return "
    <!DOCTYPE html>
    <html lang='en'>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <title>Payment Confirmation - " . APP_NAME . "</title>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #28a745, #20c997); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 10px 10px; }
            .receipt { background: white; border: 2px solid #28a745; padding: 20px; border-radius: 5px; margin: 20px 0; }
            .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>✅ Payment Successful!</h1>
                <p>Thank you for your payment</p>
            </div>
            <div class='content'>
                <h2>Hello " . htmlspecialchars($student_name) . "!</h2>
                <p>Your payment has been successfully processed. You now have access to your enrolled subjects.</p>
                
                <div class='receipt'>
                    <h3>📋 Payment Receipt</h3>
                    <p><strong>Student:</strong> " . htmlspecialchars($student_name) . "</p>
                    <p><strong>Payment Date:</strong> " . date('F j, Y \a\t g:i A') . "</p>
                    <p><strong>Total Amount:</strong> " . number_format($amount, 2) . " SZL</p>
                    <p><strong>Payment Method:</strong> MTN MoMo</p>
                    <p><strong>Status:</strong> <span style='color: #28a745; font-weight: bold;'>PAID</span></p>
                </div>
                
                <h3>📚 Enrolled Subjects:</h3>
                <ul>" . $subjects_list . "</ul>
                
                <h3>🎯 Next Steps:</h3>
                <ol>
                    <li>Your account is now fully activated</li>
                    <li>Access your learning materials immediately</li>
                    <li>Join our WhatsApp group for support</li>
                    <li>Start your learning journey!</li>
                </ol>
                
                <p><a href='" . MOODLE_URL . "' target='_blank' style='color: #6f42c1; text-decoration: none;'>🎓 Access Learning Platform</a></p>
            </div>
            <div class='footer'>
                <p>Thank you for choosing " . APP_NAME . "!</p>
                <p>This email was sent by " . APP_NAME . " Learning Platform</p>
            </div>
        </div>
    </body>
    </html>
    ";
}

// Password reset template
function getPasswordResetTemplate($student_name, $reset_link) {
    return "
    <!DOCTYPE html>
    <html lang='en'>
    <head>
        <meta charset='UTF-8'>
        <meta name='viewport' content='width=device-width, initial-scale=1.0'>
        <title>Password Reset - " . APP_NAME . "</title>
        <style>
            body { font-family: Arial, sans-serif; line-height: 1.6; color: #333; }
            .container { max-width: 600px; margin: 0 auto; padding: 20px; }
            .header { background: linear-gradient(135deg, #dc3545, #fd7e14); color: white; padding: 30px; text-align: center; border-radius: 10px 10px 0 0; }
            .content { background: #f8f9fa; padding: 30px; border-radius: 0 0 10px 10px; }
            .button { display: inline-block; background: #dc3545; color: white; padding: 15px 30px; text-decoration: none; border-radius: 5px; margin: 20px 0; }
            .footer { text-align: center; margin-top: 30px; color: #666; font-size: 14px; }
        </style>
    </head>
    <body>
        <div class='container'>
            <div class='header'>
                <h1>🔐 Password Reset Request</h1>
                <p>Reset Your Password</p>
            </div>
            <div class='content'>
                <h2>Hello " . htmlspecialchars($student_name) . "!</h2>
                <p>We received a request to reset your password for your " . APP_NAME . " account.</p>
                
                <p><strong>Click the button below to reset your password:</strong></p>
                <a href='" . $reset_link . "' class='button'>Reset Password</a>
                
                <p>If the button doesn't work, copy and paste this link into your browser:</p>
                <p style='word-break: break-all; background: #e9ecef; padding: 10px; border-radius: 5px;'>" . $reset_link . "</p>
                
                <p><strong>Important Security Information:</strong></p>
                <ul>
                    <li>This link will expire in 1 hour</li>
                    <li>If you didn't request this reset, please ignore this email</li>
                    <li>Your password will remain unchanged until you click the link</li>
                    <li>For security, this link can only be used once</li>
                </ul>
            </div>
            <div class='footer'>
                <p>This email was sent by " . APP_NAME . " Learning Platform</p>
                <p>If you have any questions, please contact our support team</p>
            </div>
        </div>
    </body>
    </html>
    ";
}