<?php

if (!function_exists('getCurriculumSubjectMap')) {
    function getCurriculumSubjectMap(): array
    {
        return [
            'Grade 4' => [
                ['name' => 'English Language', 'code' => '111'],
                ['name' => 'Mathematics', 'code' => '212'],
                ['name' => 'Siswati', 'code' => '414'],
                ['name' => 'French', 'code' => '434'],
                ['name' => 'Science', 'code' => '513'],
                ['name' => 'Social Studies', 'code' => '515'],
                ['name' => 'Agriculture', 'code' => '616'],
                ['name' => 'Consumer Science', 'code' => '627'],
                ['name' => 'Religious Education', 'code' => '631'],
                ['name' => 'Practical Arts and Technology', 'code' => '640'],
                ['name' => 'Expressive Arts', 'code' => '641'],
                ['name' => 'Health and Physical Education', 'code' => '642'],
                ['name' => 'ICT', 'code' => '645'],
            ],
            'Grade 5' => [
                ['name' => 'English Language', 'code' => '111'],
                ['name' => 'Mathematics', 'code' => '212'],
                ['name' => 'Siswati', 'code' => '414'],
                ['name' => 'French', 'code' => '434'],
                ['name' => 'Science', 'code' => '513'],
                ['name' => 'Social Studies', 'code' => '515'],
                ['name' => 'Agriculture', 'code' => '616'],
                ['name' => 'Consumer Science', 'code' => '627'],
                ['name' => 'Religious Education', 'code' => '631'],
                ['name' => 'Practical Arts and Technology', 'code' => '640'],
                ['name' => 'Expressive Arts', 'code' => '641'],
                ['name' => 'Health and Physical Education', 'code' => '642'],
                ['name' => 'ICT', 'code' => '645'],
            ],
            'Grade 6' => [
                ['name' => 'English Language', 'code' => '111'],
                ['name' => 'Mathematics', 'code' => '212'],
                ['name' => 'Siswati', 'code' => '414'],
                ['name' => 'French', 'code' => '434'],
                ['name' => 'Science', 'code' => '513'],
                ['name' => 'Social Studies', 'code' => '515'],
                ['name' => 'Agriculture', 'code' => '616'],
                ['name' => 'Consumer Science', 'code' => '627'],
                ['name' => 'Religious Education', 'code' => '631'],
                ['name' => 'Practical Arts and Technology', 'code' => '640'],
                ['name' => 'Expressive Arts', 'code' => '641'],
                ['name' => 'Health and Physical Education', 'code' => '642'],
                ['name' => 'ICT', 'code' => '645'],
            ],
            'Grade 7' => [
                ['name' => 'English Language', 'code' => '111'],
                ['name' => 'Mathematics', 'code' => '212'],
                ['name' => 'Siswati', 'code' => '414'],
                ['name' => 'French', 'code' => '434'],
                ['name' => 'Science', 'code' => '513'],
                ['name' => 'Social Studies', 'code' => '515'],
                ['name' => 'Agriculture', 'code' => '616'],
                ['name' => 'Consumer Science', 'code' => '627'],
                ['name' => 'Religious Education', 'code' => '631'],
                ['name' => 'Practical Arts and Technology', 'code' => '640'],
                ['name' => 'Expressive Arts', 'code' => '641'],
                ['name' => 'Health and Physical Education', 'code' => '642'],
                ['name' => 'ICT', 'code' => '645'],
            ],
            'Form 1' => [
                ['name' => 'English Language', 'code' => '101'],
                ['name' => 'English Literature', 'code' => '120'],
                ['name' => 'French', 'code' => '202'],
                ['name' => 'Siswati', 'code' => '207'],
                ['name' => 'Mathematics', 'code' => '309'],
                ['name' => 'Science', 'code' => '414'],
                ['name' => 'Agriculture', 'code' => '516'],
                ['name' => 'Additional Mathematics', 'code' => '519'],
                ['name' => 'Bookkeeping and Accounts', 'code' => '520'],
                ['name' => 'Business Studies', 'code' => '521'],
                ['name' => 'Development Studies', 'code' => '524'],
                ['name' => 'Geography', 'code' => '527'],
                ['name' => 'History', 'code' => '530'],
                ['name' => 'Religious Education', 'code' => '533'],
                ['name' => 'Design and Technology', 'code' => '537'],
                ['name' => 'Consumer Science', 'code' => '540'],
            ],
            'Form 2' => [
                ['name' => 'English Language', 'code' => '101'],
                ['name' => 'English Literature', 'code' => '120'],
                ['name' => 'French', 'code' => '202'],
                ['name' => 'Siswati', 'code' => '207'],
                ['name' => 'Mathematics', 'code' => '309'],
                ['name' => 'Science', 'code' => '414'],
                ['name' => 'Agriculture', 'code' => '516'],
                ['name' => 'Additional Mathematics', 'code' => '519'],
                ['name' => 'Bookkeeping and Accounts', 'code' => '520'],
                ['name' => 'Business Studies', 'code' => '521'],
                ['name' => 'Development Studies', 'code' => '524'],
                ['name' => 'Geography', 'code' => '527'],
                ['name' => 'History', 'code' => '530'],
                ['name' => 'Religious Education', 'code' => '533'],
                ['name' => 'Design and Technology', 'code' => '537'],
                ['name' => 'Consumer Science', 'code' => '540'],
            ],
            'Form 3' => [
                ['name' => 'English Language', 'code' => '101'],
                ['name' => 'English Literature', 'code' => '120'],
                ['name' => 'French', 'code' => '202'],
                ['name' => 'Siswati', 'code' => '207'],
                ['name' => 'Mathematics', 'code' => '309'],
                ['name' => 'Science', 'code' => '414'],
                ['name' => 'Agriculture', 'code' => '516'],
                ['name' => 'Additional Mathematics', 'code' => '519'],
                ['name' => 'Bookkeeping and Accounts', 'code' => '520'],
                ['name' => 'Business Studies', 'code' => '521'],
                ['name' => 'Development Studies', 'code' => '524'],
                ['name' => 'Geography', 'code' => '527'],
                ['name' => 'History', 'code' => '530'],
                ['name' => 'Religious Education', 'code' => '533'],
                ['name' => 'Design and Technology', 'code' => '537'],
                ['name' => 'Consumer Science', 'code' => '540'],
            ],
            'Form 4' => [
                ['name' => 'First Language SiSwati', 'code' => '6870'],
                ['name' => 'Siswati as a Second Language', 'code' => '6871'],
                ['name' => 'English Language', 'code' => '6873'],
                ['name' => 'Literature in English', 'code' => '6875'],
                ['name' => 'Agriculture', 'code' => '6882'],
                ['name' => 'Biology', 'code' => '6884'],
                ['name' => 'Physical Science (Chemistry/Physics)', 'code' => '6888'],
                ['name' => 'Geography', 'code' => '6890'],
                ['name' => 'History', 'code' => '6891'],
                ['name' => 'Religious Education', 'code' => '6893'],
                ['name' => 'Accounting', 'code' => '6896'],
                ['name' => 'Business Studies', 'code' => '6897'],
                ['name' => 'Economics', 'code' => '6899'],
                ['name' => 'Design and Technology', 'code' => '6902'],
                ['name' => 'Fashion and Fabrics', 'code' => '6904'],
                ['name' => 'Food and Nutrition', 'code' => '6905'],
                ['name' => 'Mathematics (Core)', 'code' => null],
                ['name' => 'Mathematics (Extended)', 'code' => null],
                ['name' => 'Art & Design', 'code' => null],
                ['name' => 'Further Mathematics', 'code' => null],
                ['name' => 'Music', 'code' => null],
                ['name' => 'Psychology', 'code' => null],
                ['name' => 'Sociology', 'code' => null],
            ],
            'Form 5' => [
                ['name' => 'First Language SiSwati', 'code' => '6870'],
                ['name' => 'Siswati as a Second Language', 'code' => '6871'],
                ['name' => 'English Language', 'code' => '6873'],
                ['name' => 'Literature in English', 'code' => '6875'],
                ['name' => 'Agriculture', 'code' => '6882'],
                ['name' => 'Biology', 'code' => '6884'],
                ['name' => 'Physical Science (Chemistry/Physics)', 'code' => '6888'],
                ['name' => 'Geography', 'code' => '6890'],
                ['name' => 'History', 'code' => '6891'],
                ['name' => 'Religious Education', 'code' => '6893'],
                ['name' => 'Accounting', 'code' => '6896'],
                ['name' => 'Business Studies', 'code' => '6897'],
                ['name' => 'Economics', 'code' => '6899'],
                ['name' => 'Design and Technology', 'code' => '6902'],
                ['name' => 'Fashion and Fabrics', 'code' => '6904'],
                ['name' => 'Food and Nutrition', 'code' => '6905'],
                ['name' => 'Mathematics (Core)', 'code' => null],
                ['name' => 'Mathematics (Extended)', 'code' => null],
                ['name' => 'Art & Design', 'code' => null],
                ['name' => 'Further Mathematics', 'code' => null],
                ['name' => 'Music', 'code' => null],
                ['name' => 'Psychology', 'code' => null],
                ['name' => 'Sociology', 'code' => null],
            ],
        ];
    }

    function curriculumGradePrefix(string $gradeName): string
    {
        if (preg_match('/Grade\s+(\d+)/i', $gradeName, $matches)) {
            return 'G' . $matches[1];
        }

        if (preg_match('/Form\s+(\d+)/i', $gradeName, $matches)) {
            return 'F' . $matches[1];
        }

        return strtoupper(substr(preg_replace('/[^A-Za-z0-9]/', '', $gradeName), 0, 3));
    }

    function getSubjectCodeMaxLength(PDO $pdo): int
    {
        $stmt = $pdo->query('DESCRIBE subjects');
        $columns = $stmt->fetchAll();

        foreach ($columns as $column) {
            if ($column['Field'] === 'code') {
                if (preg_match('/varchar\((\d+)\)/i', $column['Type'], $matches)) {
                    return (int)$matches[1];
                }
                break;
            }
        }

        return 32;
    }

    function buildCurriculumSubjectCode(string $gradeName, string $subjectName, ?string $rawCode, int $maxLength = 32): string
    {
        $prefix = curriculumGradePrefix($gradeName);

        if (!empty($rawCode)) {
            $body = strtoupper(preg_replace('/[^A-Za-z0-9]/', '', $rawCode));
        } else {
            $body = strtoupper(preg_replace('/[^A-Za-z0-9]/', '-', $subjectName));
            $body = trim($body, '-');
            $body = preg_replace('/-+/', '-', $body);
            if ($body === '') {
                $body = strtoupper(bin2hex(random_bytes(3)));
            }
        }

        $code = $prefix . '-' . $body;

        if (strlen($code) > $maxLength) {
            $code = $prefix . $body;
        }

        if (strlen($code) > $maxLength) {
            $code = substr($code, 0, $maxLength);
        }

        return $code;
    }
}


