-- =====================================================
-- TENANT FILES - SAMPLE DATA & TEST RECORDS
-- =====================================================
-- Purpose: Insert sample data for testing
-- Date: 2025-01-30
-- =====================================================

-- =====================================================
-- CLEAR EXISTING SAMPLE DATA (OPTIONAL)
-- =====================================================

DELETE FROM tenant_files WHERE tenant_id LIKE '%demo%' OR tenant_id LIKE '%test%';

-- =====================================================
-- SAMPLE DATA - SCHOOL 1 (soshigh_demo)
-- =====================================================

-- Documents
INSERT INTO tenant_files (
    tenant_id, file_category, original_filename, stored_filename, 
    file_path, file_size, mime_type, uploaded_by, 
    related_id, related_type, description, tags
) VALUES
('soshigh_demo', 'document', 'student_handbook.pdf', 'student_handbook_1706600001.pdf',
 'school_soshigh_demo/uploads/documents/student_handbook_1706600001.pdf',
 1245678, 'application/pdf', 1, NULL, NULL, 
 'Student handbook for academic year 2025', 'handbook,rules,student'),

('soshigh_demo', 'document', 'math_syllabus_form1.pdf', 'math_syllabus_form1_1706600002.pdf',
 'school_soshigh_demo/uploads/documents/math_syllabus_form1_1706600002.pdf',
 456789, 'application/pdf', 2, NULL, NULL,
 'Form 1 Mathematics syllabus', 'syllabus,math,form1'),

('soshigh_demo', 'document', 'science_practical_guide.docx', 'science_practical_1706600003.docx',
 'school_soshigh_demo/uploads/documents/science_practical_1706600003.docx',
 789012, 'application/vnd.openxmlformats-officedocument.wordprocessingml.document', 
 2, NULL, NULL, 'Science laboratory practical guide', 'science,practical,lab'),

-- Profile Photos
('soshigh_demo', 'photo', 'john_smith.jpg', 'student_1001_profile_1706600010.jpg',
 'school_soshigh_demo/uploads/profile_photos/student_1001_profile_1706600010.jpg',
 234567, 'image/jpeg', 1, 1001, 'student',
 'Profile photo for John Smith', 'profile,student,photo'),

('soshigh_demo', 'photo', 'mary_jones.jpg', 'student_1002_profile_1706600011.jpg',
 'school_soshigh_demo/uploads/profile_photos/student_1002_profile_1706600011.jpg',
 198765, 'image/jpeg', 1, 1002, 'student',
 'Profile photo for Mary Jones', 'profile,student,photo'),

('soshigh_demo', 'photo', 'teacher_doe.jpg', 'teacher_501_profile_1706600012.jpg',
 'school_soshigh_demo/uploads/profile_photos/teacher_501_profile_1706600012.jpg',
 276543, 'image/jpeg', 1, 501, 'teacher',
 'Profile photo for Mr. Doe', 'profile,teacher,staff'),

-- Payment Receipts
('soshigh_demo', 'receipt', 'tuition_receipt_jan2025.pdf', 'payment_10001_receipt_1706600020.pdf',
 'school_soshigh_demo/uploads/payment_receipts/payment_10001_receipt_1706600020.pdf',
 145678, 'application/pdf', 1, 10001, 'payment',
 'January 2025 tuition payment receipt', 'receipt,payment,tuition,january'),

('soshigh_demo', 'receipt', 'exam_fee_receipt.pdf', 'payment_10002_receipt_1706600021.pdf',
 'school_soshigh_demo/uploads/payment_receipts/payment_10002_receipt_1706600021.pdf',
 123456, 'application/pdf', 1, 10002, 'payment',
 'Examination fee receipt', 'receipt,payment,exam'),

-- Reports
('soshigh_demo', 'report', 'monthly_attendance_jan2025.xlsx', 'attendance_202501_1706600030.xlsx',
 'school_soshigh_demo/uploads/reports/attendance_202501_1706600030.xlsx',
 567890, 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
 2, NULL, 'report', 'January 2025 attendance report', 'report,attendance,january,2025'),

('soshigh_demo', 'report', 'grade_summary_term1.pdf', 'grades_term1_2025_1706600031.pdf',
 'school_soshigh_demo/uploads/reports/grades_term1_2025_1706600031.pdf',
 789012, 'application/pdf', 2, NULL, 'report',
 'Term 1 2025 grade summary report', 'report,grades,term1,2025'),

-- Backups
('soshigh_demo', 'backup', 'database_backup_20250130.sql', 'db_backup_20250130_1706600040.sql',
 'school_soshigh_demo/backups/database/db_backup_20250130_1706600040.sql',
 15678901, 'application/sql', NULL, NULL, NULL,
 'Daily database backup', 'backup,database,daily');

-- =====================================================
-- SAMPLE DATA - SCHOOL 2 (waterford_test)
-- =====================================================

INSERT INTO tenant_files (
    tenant_id, file_category, original_filename, stored_filename, 
    file_path, file_size, mime_type, uploaded_by, 
    related_id, related_type, description, tags
) VALUES
-- Documents
('waterford_test', 'document', 'school_calendar_2025.pdf', 'calendar_2025_1706600050.pdf',
 'school_waterford_test/uploads/documents/calendar_2025_1706600050.pdf',
 890123, 'application/pdf', 3, NULL, NULL,
 'Academic calendar for 2025', 'calendar,2025,academic'),

-- Photos
('waterford_test', 'photo', 'student_photo_001.jpg', 'student_2001_profile_1706600060.jpg',
 'school_waterford_test/uploads/profile_photos/student_2001_profile_1706600060.jpg',
 234567, 'image/jpeg', 3, 2001, 'student',
 'Student profile photo', 'profile,student'),

-- Receipts
('waterford_test', 'receipt', 'sports_fee_receipt.pdf', 'payment_20001_receipt_1706600070.pdf',
 'school_waterford_test/uploads/payment_receipts/payment_20001_receipt_1706600070.pdf',
 156789, 'application/pdf', 3, 20001, 'payment',
 'Sports activity fee receipt', 'receipt,payment,sports'),

-- Reports
('waterford_test', 'report', 'enrollment_report_2025.xlsx', 'enrollment_2025_1706600080.xlsx',
 'school_waterford_test/uploads/reports/enrollment_2025_1706600080.xlsx',
 456789, 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet',
 3, NULL, 'report', '2025 enrollment statistics', 'report,enrollment,2025,statistics');

-- =====================================================
-- SAMPLE ACCESS LOG DATA
-- =====================================================

INSERT INTO tenant_file_access_log (
    file_id, tenant_id, user_id, access_type, ip_address, user_agent
) VALUES
(1, 'soshigh_demo', 1, 'view', '192.168.1.100', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'),
(1, 'soshigh_demo', 2, 'download', '192.168.1.101', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'),
(2, 'soshigh_demo', 1, 'view', '192.168.1.100', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'),
(4, 'soshigh_demo', 1, 'download', '192.168.1.100', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)'),
(7, 'soshigh_demo', 1, 'view', '192.168.1.100', 'Mozilla/5.0 (Windows NT 10.0; Win64; x64)');

-- =====================================================
-- SAMPLE FILE VERSIONS DATA
-- =====================================================

INSERT INTO tenant_file_versions (
    file_id, tenant_id, version_number, stored_filename, file_path, 
    file_size, uploaded_by, version_notes
) VALUES
(2, 'soshigh_demo', 1, 'math_syllabus_form1_1706600002_v1.pdf',
 'school_soshigh_demo/uploads/documents/versions/math_syllabus_form1_1706600002_v1.pdf',
 445678, 2, 'Initial version'),
 
(2, 'soshigh_demo', 2, 'math_syllabus_form1_1706600002_v2.pdf',
 'school_soshigh_demo/uploads/documents/versions/math_syllabus_form1_1706600002_v2.pdf',
 456789, 2, 'Updated with new curriculum changes');

-- =====================================================
-- VERIFICATION
-- =====================================================

SELECT '=== SAMPLE DATA INSERTED ===' AS status;

-- Count by tenant
SELECT 
    tenant_id,
    COUNT(*) AS total_files
FROM tenant_files
GROUP BY tenant_id;

-- Count by category
SELECT 
    file_category,
    COUNT(*) AS count
FROM tenant_files
GROUP BY file_category;

-- Total storage used
SELECT 
    tenant_id,
    ROUND(SUM(file_size) / 1024 / 1024, 2) AS total_mb
FROM tenant_files
GROUP BY tenant_id;

SELECT 'Sample data ready for testing' AS message;

-- =====================================================
-- END OF SAMPLE DATA
-- =====================================================

