<?php
/**
 * Cron job script for automatic cleanup of suspended students
 * This script should be run daily to process students whose grace period has expired
 * 
 * Setup in cPanel Cron Jobs:
 * 0 2 * * * /usr/bin/php /home/yourusername/public_html/cron/cleanup_suspended_students.php
 * 
 * This runs daily at 2:00 AM
 */

// Set the working directory to the project root
chdir(dirname(__DIR__));

// Include the functions
require_once 'includes/functions.php';

// Set timezone
date_default_timezone_set('Africa/Johannesburg'); // Adjust to your timezone

echo "=== AUTOMATIC SUSPENDED STUDENTS CLEANUP ===\n";
echo "Started at: " . date('Y-m-d H:i:s') . "\n\n";

try {
    // Process expired suspended students
    $result = processExpiredSuspendedStudents();
    
    echo "Cleanup Results:\n";
    echo "- Students processed: {$result['processed']}\n";
    echo "- Errors encountered: {$result['errors']}\n";
    echo "- Total expired students: {$result['total']}\n\n";
    
    // Get current suspended students count
    $suspendedStudents = getSuspendedStudents();
    $suspendedCount = count($suspendedStudents);
    
    echo "Current Status:\n";
    echo "- Suspended students remaining: {$suspendedCount}\n";
    
    if ($suspendedCount > 0) {
        echo "\nSuspended students (next 7 days):\n";
        $upcomingDeletions = array_filter($suspendedStudents, function($student) {
            return $student['days_remaining'] <= 7 && $student['days_remaining'] > 0;
        });
        
        foreach ($upcomingDeletions as $student) {
            echo "- {$student['first_name']} {$student['last_name']} (ID: {$student['id']}) - {$student['days_remaining']} days remaining\n";
        }
    }
    
    echo "\nCleanup completed successfully at: " . date('Y-m-d H:i:s') . "\n";
    
} catch (Exception $e) {
    echo "ERROR: " . $e->getMessage() . "\n";
    error_log("Cron job error: " . $e->getMessage());
    exit(1);
}
?>
