<?php
require_once 'config.php';
require_once 'includes/sms_functions.php';

header('Content-Type: text/html; charset=utf-8');
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>📱 SMS Configuration Test</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.1/font/bootstrap-icons.css">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; padding: 20px; }
        .card { border-radius: 15px; box-shadow: 0 10px 30px rgba(0,0,0,0.2); }
        .card-header { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); color: white; border-radius: 15px 15px 0 0 !important; }
        .status-good { color: #28a745; }
        .status-bad { color: #dc3545; }
    </style>
</head>
<body>
    <div class="container mt-5">
        <div class="text-center text-white mb-4">
            <h1><i class="bi bi-phone-fill"></i> SMS Configuration Test</h1>
            <p>Test your SMS gateway integration</p>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-gear-fill"></i> SMS Settings</h5>
            </div>
            <div class="card-body">
                <table class="table table-borderless">
                    <tr>
                        <th width="250">SMS Enabled:</th>
                        <td><?= SMS_ENABLED ? '<span class="status-good">✅ Yes</span>' : '<span class="status-bad">❌ No</span>' ?></td>
                    </tr>
                    <tr>
                        <th>Provider:</th>
                        <td><code><?= SMS_PROVIDER ?></code></td>
                    </tr>
                    <tr>
                        <th>Africa's Talking Username:</th>
                        <td><code><?= AT_USERNAME ?></code></td>
                    </tr>
                    <tr>
                        <th>Africa's Talking API Key:</th>
                        <td><?= AT_API_KEY === 'your-api-key-here' ? '<span class="status-bad">❌ Not configured</span>' : '<span class="status-good">✅ Configured</span>' ?></td>
                    </tr>
                    <tr>
                        <th>Sender ID:</th>
                        <td><code><?= AT_SENDER_ID ?></code></td>
                    </tr>
                    <tr>
                        <th>Environment:</th>
                        <td><code><?= AT_ENVIRONMENT ?></code></td>
                    </tr>
                    <tr>
                        <th>Country Code:</th>
                        <td><code><?= SMS_COUNTRY_CODE ?></code></td>
                    </tr>
                    <tr>
                        <th>Verification Expiry:</th>
                        <td><?= SMS_VERIFICATION_EXPIRY ?> minutes</td>
                    </tr>
                </table>
                
                <?php if (AT_API_KEY === 'your-api-key-here'): ?>
                <div class="alert alert-warning mt-3">
                    <i class="bi bi-exclamation-triangle-fill"></i>
                    <strong>Setup Required:</strong> Please configure your Africa's Talking API key in <code>config.php</code>
                    <hr>
                    <ol class="mb-0">
                        <li>Sign up at <a href="https://africastalking.com/" target="_blank">AfricasTalking.com</a></li>
                        <li>Get your API key from the dashboard</li>
                        <li>Update <code>AT_API_KEY</code> in <code>config.php</code></li>
                    </ol>
                </div>
                <?php endif; ?>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-send-fill"></i> Send Test SMS</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="">
                    <div class="mb-3">
                        <label class="form-label">Phone Number</label>
                        <input type="tel" name="test_phone" class="form-control" 
                               placeholder="+26876000000" value="+268" required>
                        <small class="text-muted">Include country code (+268 for Eswatini)</small>
                    </div>
                    <button type="submit" name="test_sms" class="btn btn-primary">
                        <i class="bi bi-phone-fill"></i> Send Test SMS
                    </button>
                </form>
                
                <?php
                if (isset($_POST['test_sms'])) {
                    $test_phone = $_POST['test_phone'];
                    echo '<hr>';
                    echo '<h6 class="mt-3">Test Results:</h6>';
                    
                    try {
                        $result = testSMSConfiguration($test_phone);
                        
                        if ($result['success']) {
                            echo '<div class="alert alert-success">';
                            echo '<i class="bi bi-check-circle-fill"></i> <strong>Success!</strong> SMS sent successfully!';
                            echo '<hr class="my-2">';
                            echo '<small>Phone: ' . htmlspecialchars($test_phone) . '</small><br>';
                            if (isset($result['message_id'])) {
                                echo '<small>Message ID: ' . htmlspecialchars($result['message_id']) . '</small><br>';
                            }
                            if (isset($result['cost'])) {
                                echo '<small>Cost: ' . htmlspecialchars($result['cost']) . '</small>';
                            }
                            echo '</div>';
                        } else {
                            echo '<div class="alert alert-danger">';
                            echo '<i class="bi bi-x-circle-fill"></i> <strong>Error:</strong> ' . htmlspecialchars($result['error']);
                            echo '</div>';
                        }
                    } catch (Exception $e) {
                        echo '<div class="alert alert-danger">';
                        echo '<i class="bi bi-x-circle-fill"></i> <strong>Exception:</strong> ' . htmlspecialchars($e->getMessage());
                        echo '</div>';
                    }
                }
                ?>
            </div>
        </div>
        
        <div class="card mt-4">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-graph-up"></i> SMS Statistics</h5>
            </div>
            <div class="card-body">
                <?php
                try {
                    $stats = getSMSStatistics();
                    ?>
                    <div class="row text-center">
                        <div class="col-md-3">
                            <h3 class="mb-0"><?= $stats['total'] ?></h3>
                            <small class="text-muted">Total SMS</small>
                        </div>
                        <div class="col-md-3">
                            <h3 class="mb-0 text-success"><?= $stats['success'] ?></h3>
                            <small class="text-muted">Successful</small>
                        </div>
                        <div class="col-md-3">
                            <h3 class="mb-0 text-danger"><?= $stats['failed'] ?></h3>
                            <small class="text-muted">Failed</small>
                        </div>
                        <div class="col-md-3">
                            <h3 class="mb-0"><?= $stats['today'] ?></h3>
                            <small class="text-muted">Today</small>
                        </div>
                    </div>
                    <hr>
                    <div class="text-center">
                        <h4 class="mb-0"><?= $stats['success_rate'] ?>%</h4>
                        <small class="text-muted">Success Rate</small>
                    </div>
                <?php
                } catch (Exception $e) {
                    echo '<div class="alert alert-warning">';
                    echo '<i class="bi bi-database-x"></i> Database tables not created yet. Run the migration first.';
                    echo '</div>';
                }
                ?>
            </div>
        </div>
        
        <div class="text-center text-white mt-4">
            <small>
                <a href="admin/login.php" class="text-white">Back to Admin</a> | 
                <a href="index.php" class="text-white">Home</a>
            </small>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>

