<?php
require_once '../includes/functions.php';
requireAdminLogin();

$students = getStudents();
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Moodle Export Preview - <?php echo APP_NAME; ?></title>
    
    <!-- Favicon -->
    <link rel="icon" type="image/svg+xml" href="../images/img-melanesys-logo.svg">
    <link rel="alternate icon" href="../images/img-melanesys-logo.svg">
    <link rel="apple-touch-icon" href="../images/img-melanesys-logo.svg">
    
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css" rel="stylesheet">
    <style>
        :root{ --brand-primary:#6f42c1; --brand-accent:#20c997; --brand-soft:#f3f0ff; }
        body{background:linear-gradient(135deg,var(--brand-soft),#e8fff9);} 
        .hero{background: radial-gradient(1000px 400px at 10% 0%, rgba(111,66,193,.15), rgba(32,201,151,.1)), linear-gradient(135deg, rgba(111,66,193,.12), rgba(32,201,151,.12)); border-radius: 1rem;}
        .brand-underline{position:relative; display:inline-block}
        .brand-underline::after{content:""; position:absolute; left:0; right:0; bottom:-.25rem; height:.35rem; background:linear-gradient(90deg,var(--brand-primary),var(--brand-accent)); border-radius:1rem}
        .card-modern{border:0; box-shadow:0 1rem 2rem rgba(0,0,0,.07);}
        .btn-gradient{background:linear-gradient(90deg,var(--brand-primary),var(--brand-accent)); border:0}
        .btn-gradient:hover{filter:brightness(.95)}
    </style>
</head>
<body>
    <div class="container py-4">
        <div class="hero p-4 p-md-5 mb-4 text-dark">
            <div class="d-flex align-items-center justify-content-between">
                <div>
                    <h1 class="display-6 fw-bold mb-2 brand-underline">Moodle Export Preview</h1>
                    <p class="mb-0">Preview and download student data for Moodle import</p>
                </div>
                <a href="dashboard.php" class="btn btn-outline-secondary">
                    <i class="bi bi-arrow-left me-1"></i>Back to Dashboard
                </a>
            </div>
        </div>

        <div class="row g-4">
            <div class="col-12">
                <div class="card card-modern">
                    <div class="card-header bg-white">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-download me-2"></i>Export Options
                        </h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="bi bi-info-circle me-2"></i>
                            <strong>Moodle Import Format:</strong> The export will include columns in this exact order: 
                            <code>username</code>, <code>firstname</code>, <code>lastname</code>, <code>password</code>, <code>email</code>, <code>grade</code>, <code>subjects</code>
                        </div>
                        
                        <div class="alert alert-warning">
                            <i class="bi bi-exclamation-triangle me-2"></i>
                            <strong>Password Note:</strong> Student passwords are set to their last name for Moodle import. 
                            Students should change these passwords after first login.
                        </div>

                        <div class="d-grid gap-2 d-md-flex">
                            <a href="export_moodle.php" class="btn btn-gradient text-white">
                                <i class="bi bi-file-earmark-text me-1"></i>Download CSV for Moodle
                            </a>
                            <a href="../exports/students.xlsx" class="btn btn-outline-primary">
                                <i class="bi bi-file-earmark-excel me-1"></i>Download Excel File
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <div class="col-12">
                <div class="card card-modern">
                    <div class="card-header bg-white">
                        <h5 class="card-title mb-0">
                            <i class="bi bi-table me-2"></i>Preview Data (<?php echo count($students); ?> students)
                        </h5>
                    </div>
                    <div class="card-body">
                        <?php if (empty($students)): ?>
                            <p class="text-muted">No students found.</p>
                        <?php else: ?>
                            <!-- Search Filter -->
                            <div class="row mb-3">
                                <div class="col-12">
                                    <div class="card bg-light">
                                        <div class="card-body py-3">
                                            <div class="row g-2">
                                                <div class="col-md-2">
                                                    <label class="form-label small fw-bold">Username</label>
                                                    <input type="text" class="form-control form-control-sm" id="filter-username" placeholder="Search username...">
                                                </div>
                                                <div class="col-md-2">
                                                    <label class="form-label small fw-bold">First Name</label>
                                                    <input type="text" class="form-control form-control-sm" id="filter-firstname" placeholder="Search first name...">
                                                </div>
                                                <div class="col-md-2">
                                                    <label class="form-label small fw-bold">Last Name</label>
                                                    <input type="text" class="form-control form-control-sm" id="filter-lastname" placeholder="Search last name...">
                                                </div>
                                                <div class="col-md-2">
                                                    <label class="form-label small fw-bold">Password</label>
                                                    <input type="text" class="form-control form-control-sm" id="filter-password" placeholder="Search password...">
                                                </div>
                                                <div class="col-md-2">
                                                    <label class="form-label small fw-bold">Email</label>
                                                    <input type="text" class="form-control form-control-sm" id="filter-email" placeholder="Search email...">
                                                </div>
                                                <div class="col-md-1">
                                                    <label class="form-label small fw-bold">Grade</label>
                                                    <input type="text" class="form-control form-control-sm" id="filter-grade" placeholder="Grade...">
                                                </div>
                                                <div class="col-md-1">
                                                    <label class="form-label small fw-bold">Subjects</label>
                                                    <input type="text" class="form-control form-control-sm" id="filter-subjects" placeholder="Subjects...">
                                                </div>
                                            </div>
                                            <div class="row mt-2">
                                                <div class="col-12">
                                                    <button type="button" class="btn btn-sm btn-outline-secondary" id="clear-filters">
                                                        <i class="bi bi-x-circle me-1"></i>Clear All Filters
                                                    </button>
                                                    <span class="ms-3 text-muted small">
                                                        <span id="filter-results-count"><?php echo count($students); ?></span> students shown
                                                    </span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="table-responsive" style="max-height: 600px; overflow-y: auto; border: 1px solid #dee2e6; border-radius: 0.375rem;">
                                <table class="table table-striped table-sm mb-0" id="students-table">
                                    <thead class="table-light sticky-top">
                                        <tr>
                                            <th style="position: sticky; top: 0; background-color: #f8f9fa; z-index: 10;">Username</th>
                                            <th style="position: sticky; top: 0; background-color: #f8f9fa; z-index: 10;">First Name</th>
                                            <th style="position: sticky; top: 0; background-color: #f8f9fa; z-index: 10;">Last Name</th>
                                            <th style="position: sticky; top: 0; background-color: #f8f9fa; z-index: 10;">Password</th>
                                            <th style="position: sticky; top: 0; background-color: #f8f9fa; z-index: 10;">Email</th>
                                            <th style="position: sticky; top: 0; background-color: #f8f9fa; z-index: 10;">Grade</th>
                                            <th style="position: sticky; top: 0; background-color: #f8f9fa; z-index: 10;">Subjects</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach (array_slice($students, 0, 100) as $student): ?>
                                        <?php 
                                            $subjects = getSubjectsForStudent($student['id']);
                                            $subjectNames = array_map(function($s) { return $s['name']; }, $subjects);
                                            $subjectsString = implode(', ', $subjectNames);
                                            $tempPassword = $student['last_name'];
                                        ?>
                                        <tr>
                                            <td><code><?php echo htmlspecialchars(formatUsernameForMoodle($student['username'])); ?></code></td>
                                            <td><?php echo htmlspecialchars($student['first_name']); ?></td>
                                            <td><?php echo htmlspecialchars($student['last_name']); ?></td>
                                            <td><code><?php echo htmlspecialchars($tempPassword); ?></code></td>
                                            <td><?php echo htmlspecialchars($student['email']); ?></td>
                                            <td><?php echo htmlspecialchars($student['grade_name']); ?></td>
                                            <td><?php echo htmlspecialchars($subjectsString); ?></td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                            <?php if (count($students) > 100): ?>
                                <div class="mt-3 text-center">
                                    <p class="text-muted">
                                        <i class="bi bi-info-circle me-1"></i>
                                        Showing first 100 of <?php echo count($students); ?> students. 
                                        Download the full export to see all students.
                                    </p>
                                </div>
                            <?php elseif (count($students) > 10): ?>
                                <div class="mt-3 text-center">
                                    <p class="text-muted">
                                        <i class="bi bi-check-circle me-1"></i>
                                        Showing all <?php echo count($students); ?> students
                                    </p>
                                </div>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const table = document.getElementById('students-table');
            const tbody = table.querySelector('tbody');
            const rows = Array.from(tbody.querySelectorAll('tr'));
            const filterInputs = {
                username: document.getElementById('filter-username'),
                firstname: document.getElementById('filter-firstname'),
                lastname: document.getElementById('filter-lastname'),
                password: document.getElementById('filter-password'),
                email: document.getElementById('filter-email'),
                grade: document.getElementById('filter-grade'),
                subjects: document.getElementById('filter-subjects')
            };
            const clearButton = document.getElementById('clear-filters');
            const resultsCount = document.getElementById('filter-results-count');

            // Function to filter rows
            function filterRows() {
                const filters = {};
                
                // Get filter values
                Object.keys(filterInputs).forEach(key => {
                    filters[key] = filterInputs[key].value.toLowerCase().trim();
                });

                let visibleCount = 0;

                rows.forEach(row => {
                    const cells = row.querySelectorAll('td');
                    let showRow = true;

                    // Check each filter
                    Object.keys(filters).forEach((filterKey, index) => {
                        if (filters[filterKey] && showRow) {
                            const cellText = cells[index].textContent.toLowerCase();
                            if (!cellText.includes(filters[filterKey])) {
                                showRow = false;
                            }
                        }
                    });

                    // Show/hide row
                    if (showRow) {
                        row.style.display = '';
                        visibleCount++;
                    } else {
                        row.style.display = 'none';
                    }
                });

                // Update results count
                resultsCount.textContent = visibleCount;
            }

            // Add event listeners to all filter inputs
            Object.values(filterInputs).forEach(input => {
                input.addEventListener('input', filterRows);
                input.addEventListener('keyup', filterRows);
            });

            // Clear filters button
            clearButton.addEventListener('click', function() {
                Object.values(filterInputs).forEach(input => {
                    input.value = '';
                });
                filterRows();
            });

            // Initial filter (in case there are any pre-filled values)
            filterRows();
        });
    </script>
</body>
</html>
