# Production Server Installation - Payment Reminder System

## 🎯 For Production Server with Restricted Permissions

Your server user `melane_super_tenant@localhost` has restricted access, so follow these steps:

---

## 📋 Installation Steps

### **STEP 1: Import Main Tables** (Via cPanel PHPMyAdmin)

1. **Login to cPanel** → PHPMyAdmin
2. **Select your database** (left sidebar)
3. **Click "Import" tab**
4. **Choose file:** `database/migrations/create_payment_reminder_system_FIXED.sql`
5. **Click "Go"**
6. **Wait for success message**

This creates:
- ✅ 7 tables
- ✅ 2 stored procedures
- ✅ Default settings for all schools
- ✅ Adds suspension columns to students table

---

### **STEP 2: Create Database Views** (Separate Import)

1. **Still in PHPMyAdmin**
2. **Click "Import" tab** again
3. **Choose file:** `database/migrations/create_payment_views.sql`
4. **Click "Go"**

This creates:
- ✅ `v_students_need_reminder`
- ✅ `v_students_need_warning`
- ✅ `v_students_to_suspend`

---

### **STEP 3: Upload PHP Files to Server**

Upload these files to your production server:

```
📁 Upload to: public_html/Multi-Tanent/ or your root directory

Files to upload:
├── includes/
│   ├── payment_reminder_manager.php          ✅
│   ├── moodle_suspension_handler.php         ✅
│   └── url_helper.php                        ✅ (already exists)
│
├── cron/
│   └── payment_reminder_cron.php             ✅
│
├── admin/
│   └── settings/
│       ├── payment_settings.php              ✅
│       └── manage_student_payments.php       ✅
│
├── pay_reminder.php                          ✅
├── process_reminder_payment.php              ✅
├── payment_status_reminder.php               ✅
├── webhook_payment_confirmation.php          ✅
├── initialize_payment_system.php             ✅
└── test_payment_reminder.php                 ✅
```

**Upload Method:**
- Use FileZilla / cPanel File Manager
- Upload via FTP
- Or use cPanel's "Upload" feature

---

### **STEP 4: Initialize System** (Via Web Browser)

1. **Open browser**
2. **Go to:** `https://test.melanegroup.com/Multi-Tanent/initialize_payment_system.php`
3. **Wait for completion** (30-60 seconds)
4. **Check for success message:**
   ```
   ✅ INITIALIZATION COMPLETE!
   ```

This will:
- Verify all tables exist
- Create default settings for all schools
- Initialize payment schedules for existing students
- Validate setup

---

### **STEP 5: Configure Cron Job** (Via cPanel)

1. **Login to cPanel**
2. **Find "Cron Jobs"** in Advanced section
3. **Click "Add New Cron Job"**
4. **Configure:**
   - **Minute:** 0
   - **Hour:** 8
   - **Day:** *
   - **Month:** *
   - **Weekday:** *
   - **Command:** 
     ```
     /usr/bin/php /home/USERNAME/public_html/Multi-Tanent/cron/payment_reminder_cron.php
     ```
     (Replace USERNAME with your actual cPanel username)
5. **Click "Add New Cron Job"**

This runs the automated system daily at 8:00 AM.

---

### **STEP 6: Configure Payment Settings**

1. **Login to admin dashboard:**
   ```
   https://test.melanegroup.com/Multi-Tanent/admin/login.php
   ```

2. **Navigate to:**
   ```
   Settings → Payment Settings
   OR
   admin/settings/payment_settings.php
   ```

3. **Configure for TEST school:**
   - Payment Cycle: 30 days
   - Reminder After: 27 days
   - Warning After: 3 days
   - Suspend After: 35 days
   - Monthly Fee: SZL 350.00
   - Unsuspension Fee: SZL 50.00
   - ✅ Enable all automation
   - ✅ Enable email notifications
   - ✅ Enable SMS notifications

4. **Click "Save Payment Settings"**

---

### **STEP 7: Test the System**

**Test 1: Check Installation**
```
https://test.melanegroup.com/Multi-Tanent/test_payment_reminder.php
```

Expected: All tests pass ✅

**Test 2: Send Test Reminder**
1. Go to: `admin/settings/manage_student_payments.php`
2. Find a student
3. Click envelope icon (📧 Send Reminder)
4. Check student's email
5. Click payment link to test

**Test 3: Check Database**
Via PHPMyAdmin:
```sql
-- Check tables created
SHOW TABLES LIKE '%payment%';

-- Check settings
SELECT * FROM tenant_payment_settings;

-- Check schedules
SELECT COUNT(*) FROM student_payment_schedules;
```

---

### **STEP 8: Monitor First Automated Run**

Wait for the cron job to run (next day at 8 AM), then check:

**Via cPanel:**
1. Go to Cron Jobs
2. Check "Cron Email" for execution report

**Via Database:**
```sql
-- Check reminders sent
SELECT * FROM payment_reminders 
ORDER BY sent_at DESC LIMIT 10;

-- Check audit log
SELECT * FROM payment_system_audit_log 
ORDER BY created_at DESC LIMIT 20;
```

---

## ✅ Verification Checklist

After installation, verify:

```
[ ] Database tables created (7 tables)
[ ] Database views created (3 views)
[ ] Stored procedures created (2 procedures)
[ ] PHP files uploaded to server
[ ] Initialization script ran successfully
[ ] Payment schedules exist for all students
[ ] Default settings exist for all schools
[ ] Cron job configured in cPanel
[ ] Test script passes all tests
[ ] Admin dashboards accessible
[ ] Payment settings page works
[ ] Student management page works
[ ] Test reminder sent successfully
[ ] Email received
[ ] SMS received (if configured)
[ ] Payment link works
[ ] Moodle API connection verified
```

---

## 🚨 Troubleshooting Production Issues

### **Issue: Foreign Key Constraints Fail**

If you get foreign key errors:

```sql
-- Temporarily disable foreign key checks
SET FOREIGN_KEY_CHECKS=0;

-- Import the FIXED SQL file

-- Re-enable foreign key checks
SET FOREIGN_KEY_CHECKS=1;
```

### **Issue: Views Creation Fails**

Import views separately:
1. Import `create_payment_reminder_system_FIXED.sql` first (tables only)
2. Then import `create_payment_views.sql` (views only)

### **Issue: Stored Procedures Already Exist**

Drop and recreate:
```sql
DROP PROCEDURE IF EXISTS sp_init_student_payment_schedule;
DROP PROCEDURE IF EXISTS sp_process_payment_success;

-- Then run the DELIMITER section from the SQL file
```

### **Issue: Cron Not Running**

Check cPanel Cron Jobs:
1. Verify command path is correct
2. Check cron email for errors
3. Test manually via browser:
   ```
   https://test.melanegroup.com/Multi-Tanent/cron/payment_reminder_cron.php
   ```
   (Should show execution log)

### **Issue: Permission Denied on Logs**

Create logs directory with proper permissions:
```bash
# Via cPanel File Manager or SSH
mkdir -p logs
chmod 755 logs
touch logs/payment_reminder_cron.log
chmod 644 logs/payment_reminder_cron.log
```

---

## 📊 Post-Installation Checks

### **Check Tables:**
```sql
SHOW CREATE TABLE tenant_payment_settings;
SHOW CREATE TABLE student_payment_schedules;
```

### **Check Views:**
```sql
SELECT * FROM v_students_need_reminder LIMIT 5;
SELECT * FROM v_students_need_warning LIMIT 5;
SELECT * FROM v_students_to_suspend LIMIT 5;
```

### **Check Procedures:**
```sql
SHOW PROCEDURE STATUS WHERE Db = 'your_database_name';
```

---

## 🎉 Success!

Once all steps complete:

✅ System is **LIVE**  
✅ Will run **automatically** daily  
✅ Will send **reminders** at Day 27  
✅ Will send **warnings** at Day 30  
✅ Will **suspend** at Day 35  
✅ Will **unsuspend** upon payment  

**All completely automated!** 🚀

---

## 📞 Quick Help

**Can't import SQL?**
→ Use the FIXED version: `create_payment_reminder_system_FIXED.sql`

**Views failing?**
→ Import separately: `create_payment_views.sql`

**Cron not working?**
→ Test via browser first, check cPanel cron email

**Need to reset?**
→ Drop all tables and start over:
```sql
DROP TABLE IF EXISTS payment_system_audit_log;
DROP TABLE IF EXISTS payment_notification_templates;
DROP TABLE IF EXISTS suspension_logs;
DROP TABLE IF EXISTS payment_transactions;
DROP TABLE IF EXISTS payment_reminders;
DROP TABLE IF EXISTS student_payment_schedules;
DROP TABLE IF EXISTS tenant_payment_settings;
```

---

**Ready to install? Start with STEP 1!** 🚀

