# 🚀 Payment Reminder System - Installation Instructions

## ✅ System Fully Implemented - Ready to Install

---

## 📦 What Has Been Created

### **Files Created: 14 Files**

#### **Database Schema:**
1. `database/migrations/create_payment_reminder_system.sql` - Complete database schema

#### **Core Classes:**
2. `includes/payment_reminder_manager.php` - Payment reminder manager
3. `includes/moodle_suspension_handler.php` - Moodle suspension API handler

#### **Cron Jobs:**
4. `cron/payment_reminder_cron.php` - Daily automated processing

#### **Payment Pages:**
5. `pay_reminder.php` - Secure payment page
6. `process_reminder_payment.php` - Payment processor
7. `payment_status_reminder.php` - Real-time status checker
8. `webhook_payment_confirmation.php` - Webhook handler

#### **Admin Dashboards:**
9. `admin/settings/payment_settings.php` - Configuration dashboard
10. `admin/settings/manage_student_payments.php` - Student management

#### **Setup & Testing:**
11. `initialize_payment_system.php` - One-time initialization script
12. `test_payment_reminder.php` - Testing utility

#### **Documentation:**
13. `PAYMENT_REMINDER_SYSTEM_SETUP_GUIDE.md` - Complete setup guide
14. `PAYMENT_REMINDER_SYSTEM_COMPLETE.md` - Full documentation
15. `PAYMENT_SYSTEM_QUICK_REFERENCE.md` - Quick reference
16. `PAYMENT_SYSTEM_IMPLEMENTATION_SUMMARY.txt` - Summary
17. This file: `INSTALLATION_INSTRUCTIONS.md`

---

## 🔧 Installation Steps

### **STEP 1: Install Database Schema**

**Option A: Via PHPMyAdmin (Recommended for Windows/XAMPP)**

1. Open your browser and go to: `http://localhost/phpmyadmin`
2. Login (usually no password for XAMPP)
3. Click on `multi_tenant_skoloi` database in the left sidebar
4. Click the "Import" tab at the top
5. Click "Choose File" button
6. Navigate to: `C:\xampp\htdocs\Multi-Tanent\database\migrations\create_payment_reminder_system.sql`
7. Click "Go" button at the bottom
8. Wait for success message: "Import has been successfully finished"

**Expected Result:**
```
✓ 7 tables created
✓ 3 views created
✓ 2 stored procedures created
✓ Default settings inserted
```

**Option B: Via MySQL Command Line**

```bash
# Open Command Prompt as Administrator
cd C:\xampp\mysql\bin

# Run migration
mysql.exe -u root multi_tenant_skoloi < "C:\xampp\htdocs\Multi-Tanent\database\migrations\create_payment_reminder_system.sql"
```

---

### **STEP 2: Initialize the System**

**Option A: Via Web Browser**

1. Open browser
2. Go to: `http://localhost/Multi-Tanent/initialize_payment_system.php`
3. Wait for completion (may take 30-60 seconds)
4. Check for success message

**Option B: Via Command Line**

```bash
cd C:\xampp\htdocs\Multi-Tanent
php initialize_payment_system.php
```

**What This Does:**
- Validates database tables exist
- Creates default settings for all schools
- Initializes payment schedules for existing students
- Validates table structure
- Reports status

**Expected Output:**
```
✓ All required tables exist
✓ Settings initialized for X tenants
✓ Initialized Y payment schedules
✅ INITIALIZATION COMPLETE!
```

---

### **STEP 3: Test the System**

**Via Web Browser:**
```
http://localhost/Multi-Tanent/test_payment_reminder.php
```

**Via Command Line:**
```bash
cd C:\xampp\htdocs\Multi-Tanent
php test_payment_reminder.php
```

**Expected Output:**
```
✓ Payment link generated
✓ Token decryption successful
✓ Reminder sent successfully
✓ Database views: OK
✅ ALL TESTS COMPLETED!
```

---

### **STEP 4: Configure Cron Job**

**For Windows/XAMPP:**

Since Windows doesn't have native cron, use **Task Scheduler**:

1. Open Task Scheduler (search in Start menu)
2. Click "Create Basic Task"
3. Name: "Payment Reminder System"
4. Trigger: Daily
5. Time: 8:00 AM
6. Action: Start a program
7. Program: `C:\xampp\php\php.exe`
8. Arguments: `C:\xampp\htdocs\Multi-Tanent\cron\payment_reminder_cron.php`
9. Click Finish

**For Linux/Production Server:**

```bash
crontab -e

# Add this line
0 8 * * * /usr/bin/php /path/to/Multi-Tanent/cron/payment_reminder_cron.php >> /path/to/logs/payment_cron.log 2>&1
```

---

### **STEP 5: Configure Payment Settings**

1. **Access Admin Dashboard:**
   - URL: `http://localhost/Multi-Tanent/admin/login.php`
   - Login with your admin credentials

2. **Navigate to Payment Settings:**
   - Click "Settings" in menu
   - Select "Payment Settings" (or go to `admin/settings/payment_settings.php`)

3. **Configure for Your School:**
   - **Payment Cycle:** 30 days (monthly)
   - **Reminder After:** 27 days
   - **Warning After:** 3 days (after reminder)
   - **Suspend After:** 35 days total
   - **Monthly Fee:** SZL 350.00 (adjust as needed)
   - **Unsuspension Fee:** SZL 50.00 (or 0 to waive)
   - **Enable Automation:** Check all boxes
   - **Notification Channels:** Enable Email + SMS

4. **Save Settings**

---

### **STEP 6: Verify Installation**

**Check Database Tables Created:**
```sql
-- Via PHPMyAdmin or MySQL command line
USE multi_tenant_skoloi;

SHOW TABLES LIKE '%payment%';
SHOW TABLES LIKE '%suspension%';

-- Should show:
-- tenant_payment_settings
-- student_payment_schedules
-- payment_reminders
-- payment_transactions
-- suspension_logs
-- payment_notification_templates
-- payment_system_audit_log
```

**Check Payment Schedules Initialized:**
```sql
SELECT COUNT(*) as total_schedules FROM student_payment_schedules;
```

**Check Settings Created:**
```sql
SELECT academy_reference, monthly_fee, auto_suspend_enabled 
FROM tenant_payment_settings;
```

---

### **STEP 7: Test End-to-End**

1. **Test Payment Reminder:**
   - Go to: `admin/settings/manage_student_payments.php`
   - Find a student
   - Click "Send Reminder" button
   - Check student's email for reminder
   - Check if SMS was sent (if configured)

2. **Test Payment Link:**
   - Click the payment link from the email
   - Should open `pay_reminder.php`
   - Should show payment amount and methods
   - Should display student information

3. **Test Suspension (Optional):**
   - From student management page
   - Click "Suspend" button for a test student
   - Verify student is suspended in Moodle
   - Check suspension logs

4. **Test Unsuspension:**
   - Click "Unsuspend" button
   - Verify student is unsuspended in Moodle
   - Check logs updated

---

## 🎯 Verification Checklist

After installation, verify:

- [ ] Database migration completed without errors
- [ ] 7 new tables exist in database
- [ ] 3 database views created
- [ ] 2 stored procedures created
- [ ] Initialization script ran successfully
- [ ] Payment schedules created for existing students
- [ ] Default settings exist for all tenants
- [ ] Test script passed all tests
- [ ] Admin dashboard accessible
- [ ] Payment settings page works
- [ ] Student management page works
- [ ] Cron job/Task Scheduler configured
- [ ] Logs directory exists and is writable
- [ ] Email sending works
- [ ] SMS sending works (if configured)
- [ ] Moodle API connection works
- [ ] Payment link generation works
- [ ] Token encryption/decryption works

---

## 📋 Next Steps After Installation

### **1. Configure for Each School/Tenant**

For each school in your system:
1. Login as admin
2. Select the school
3. Go to Payment Settings
4. Customize timeline and fees
5. Save

### **2. Monitor First Run**

Watch the first cron execution:
```bash
# Windows: Check Task Scheduler history
# Linux: 
tail -f logs/payment_reminder_cron.log
```

### **3. Review & Adjust**

After first week:
- Review reminder effectiveness
- Check suspension rate
- Adjust timeline if needed
- Fine-tune fees

### **4. Train Admin Staff**

Show administrators:
- How to access dashboards
- How to manually suspend/unsuspend
- How to send manual reminders
- How to view payment history
- How to interpret logs

---

## 🔍 Troubleshooting

### **Issue: Database Migration Fails**

**Solution:**
1. Check MySQL is running (XAMPP Control Panel → MySQL → Start)
2. Verify database exists: `multi_tenant_skoloi`
3. Check for syntax errors in SQL file
4. Run migration via PHPMyAdmin (more forgiving)

### **Issue: Initialization Script Errors**

**Check:**
```bash
# Verify PHP can find files
php -r "require_once 'config.php'; echo 'Config loaded';"

# Check database connection
php -r "require_once 'config.php'; $pdo = getDB(); echo 'DB connected';"
```

### **Issue: Cron/Task Not Running**

**Windows Task Scheduler:**
1. Open Task Scheduler
2. Find your task
3. Right-click → Run
4. Check "Last Run Result" (should be 0x0 for success)
5. Check logs: `logs/payment_reminder_cron.log`

**Linux:**
```bash
# Test manual run
php cron/payment_reminder_cron.php

# Check cron logs
grep payment /var/log/syslog
```

### **Issue: Emails Not Sending**

**Check:**
1. SMTP settings in `config.php`
2. Test email manually:
   ```php
   require_once 'includes/email_functions.php';
   $result = sendEmail('test@example.com', 'Test', 'Subject', 'Body');
   echo $result ? 'Success' : 'Failed';
   ```
3. Check `email_logs` table for errors

### **Issue: Moodle Suspension Fails**

**Check:**
1. `MOODLE_API_TOKEN` is valid
2. Student has `moodle_user_id` set
3. Moodle web services enabled
4. Test connection:
   ```php
   require_once 'includes/moodle_suspension_handler.php';
   $handler = new MoodleSuspensionHandler();
   $status = $handler->getSuspensionStatus($student_id);
   print_r($status);
   ```

---

## 📞 Support

### **Documentation Files:**
- `PAYMENT_REMINDER_SYSTEM_SETUP_GUIDE.md` - Complete setup
- `PAYMENT_REMINDER_SYSTEM_COMPLETE.md` - Full documentation
- `PAYMENT_SYSTEM_QUICK_REFERENCE.md` - Quick reference

### **Log Files:**
- `logs/payment_reminder_cron.log` - Cron execution
- `logs/payment_webhook.log` - Payment webhooks
- Database table: `payment_system_audit_log`

### **Testing:**
```bash
php test_payment_reminder.php
```

---

## 🎉 You're All Set!

Once you complete these installation steps, your payment reminder and suspension system will be:

✅ **Fully automated**  
✅ **Running daily**  
✅ **Sending reminders**  
✅ **Suspending accounts**  
✅ **Processing payments**  
✅ **Unsuspending automatically**  

**With ZERO manual work required!**

---

## 🚦 Quick Start Checklist

```
[ ] Step 1: Import SQL file via PHPMyAdmin
[ ] Step 2: Run initialize_payment_system.php
[ ] Step 3: Run test_payment_reminder.php
[ ] Step 4: Setup Windows Task Scheduler
[ ] Step 5: Configure payment settings per school
[ ] Step 6: Verify all checks passed
[ ] Step 7: Test with one student
[ ] Step 8: Monitor first automated run
[ ] Step 9: Review logs
[ ] Step 10: System live! 🎊
```

---

**Installation Time: ~15-20 minutes**  
**Ready for Production: Immediately after testing**

Good luck! 🚀

