# ✅ Fix "Class PDO Not Found" Error

## 🎯 The Problem

**Error:** `Fatal error: Uncaught Error: Class "PDO" not found`

**Good News:** The header errors are FIXED! ✅  
**New Issue:** PDO extension is not enabled on your cPanel server

**What is PDO?**
- PDO (PHP Data Objects) is required for database connections
- It's a PHP extension that must be enabled on the server
- Your code uses PDO to connect to MySQL

---

## 🚀 SOLUTION: Enable PDO Extension in cPanel

### **Method 1: Via cPanel PHP Selector (Easiest)**

#### **Step 1: Access PHP Selector**
1. **Login to cPanel:** `https://melanegroup.com:2083`
2. Search for: **"Select PHP Version"** or **"PHP Selector"**
3. Click on it

#### **Step 2: Enable PDO Extensions**
1. You'll see a list of PHP extensions
2. **Check these boxes:**
   - ✅ `pdo`
   - ✅ `pdo_mysql`
   - ✅ `mysqli` (good to have)
   - ✅ `mysqlnd` (MySQL Native Driver)

3. **Click "Save"** or **"Apply"**

#### **Step 3: Verify PHP Version**
While you're there:
- Make sure **PHP version is 7.4 or higher** (8.0, 8.1, 8.2 recommended)
- If it's lower, select a newer version

#### **Step 4: Test**
- Visit your login page again
- Should work now!

---

## 🚀 SOLUTION 2: Via MultiPHP INI Editor

If you can't find PHP Selector:

#### **Step 1: Access MultiPHP INI Editor**
1. cPanel Home
2. Search for: **"MultiPHP INI Editor"**
3. Click on it

#### **Step 2: Select Your Domain**
1. Select: `test.melanegroup.com`
2. Look for extension settings

#### **Step 3: Enable Extensions**
Add these lines if not present:
```ini
extension=pdo.so
extension=pdo_mysql.so
extension=mysqli.so
```

#### **Step 4: Save and Test**

---

## 🚀 SOLUTION 3: Check .htaccess or php.ini

### **Create/Edit php.ini in Your Site Root**

1. **cPanel → File Manager**
2. Navigate to: `/public_html/test.melanegroup.com/Multi-Tanent/`
3. Create file: `php.ini` (if doesn't exist)
4. Add these lines:
```ini
; Enable PDO extensions
extension=pdo.so
extension=pdo_mysql.so
extension=mysqli.so

; Memory and execution settings
memory_limit = 256M
max_execution_time = 300
upload_max_filesize = 50M
post_max_size = 50M
```

5. **Save**
6. **Test your site**

---

## 🚀 SOLUTION 4: Contact Hosting Support (If Above Don't Work)

If none of the above work:

### **Contact Your Host:**

**Email/Ticket Template:**
```
Subject: Enable PDO Extension for PHP

Hello,

I need the following PHP extensions enabled for my domain:
- test.melanegroup.com

Required extensions:
- pdo
- pdo_mysql
- mysqli
- mysqlnd

Current PHP version: [check in cPanel]
Desired PHP version: 8.0 or higher

The site is showing error: "Class PDO not found"

Please enable these extensions at your earliest convenience.

Thank you!
```

---

## ✅ Verify PDO is Enabled

### **Create test file: phpinfo.php**

Upload this to your server root:

```php
<?php
phpinfo();
```

Visit: `https://test.melanegroup.com/Multi-Tanent/phpinfo.php`

**Search for:**
- `PDO` - should show "enabled"
- `PDO drivers` - should show "mysql"
- `pdo_mysql` - should show "enabled"

**⚠️ Delete this file after checking!** (Security risk to leave it)

---

## 🔍 Alternative: Quick PDO Check

Create: `check_pdo.php`

```php
<?php
echo "PHP Version: " . PHP_VERSION . "<br><br>";

if (extension_loaded('pdo')) {
    echo "✅ PDO extension is loaded<br>";
} else {
    echo "❌ PDO extension is NOT loaded<br>";
}

if (extension_loaded('pdo_mysql')) {
    echo "✅ PDO MySQL driver is loaded<br>";
} else {
    echo "❌ PDO MySQL driver is NOT loaded<br>";
}

echo "<br>Available PDO drivers:<br>";
print_r(PDO::getAvailableDrivers());
```

Visit this file and see the results.

**Expected Output:**
```
PHP Version: 8.1.x

✅ PDO extension is loaded
✅ PDO MySQL driver is loaded

Available PDO drivers:
Array ( [0] => mysql )
```

---

## 📊 Common cPanel Locations for PHP Settings

### **Where to Find:**

1. **"Select PHP Version"** (most common)
   - Usually in cPanel home under "Software" section
   - Or search for it in cPanel search bar

2. **"MultiPHP Manager"**
   - Alternative to PHP Selector
   - Allows selecting PHP version per domain

3. **"MultiPHP INI Editor"**
   - For editing PHP configuration
   - Per-domain settings

4. **"Software" Section**
   - Usually contains all PHP-related tools

---

## 🎯 Most Likely Scenario

**Your hosting probably has:**
- ✅ PHP installed
- ❌ PDO extension disabled by default
- ✅ Option to enable via cPanel

**Solution:**
1. Find "Select PHP Version" in cPanel
2. Check the PDO boxes
3. Save
4. Done!

---

## ⚠️ Important Notes

### **About PHP Versions:**

- **PHP 7.4+** - Minimum required
- **PHP 8.0+** - Recommended
- **PHP 8.2** - Best performance

PDO comes built-in with PHP but might be disabled in cPanel for some reason.

### **About Extensions:**

**Absolutely Required:**
- `pdo` - Core PDO extension
- `pdo_mysql` - MySQL driver for PDO
- `mbstring` - String handling
- `json` - JSON operations

**Highly Recommended:**
- `mysqli` - Alternative MySQL interface
- `curl` - HTTP requests (for APIs)
- `openssl` - Encryption
- `zip` - File compression
- `gd` - Image manipulation

---

## 🚨 If You Can't Enable Extensions

### **Plan B: Use MySQLi Instead**

If you absolutely can't enable PDO, I can modify your code to use MySQLi instead.

**But first, try enabling PDO - it's easier!**

---

## ✅ After Enabling PDO

### **Expected Results:**

1. **Visit login page:**
   ```
   https://test.melanegroup.com/Multi-Tanent/admin/login.php
   ```

2. **Should load cleanly:**
   - ✅ No warnings
   - ✅ No PDO errors
   - ✅ Login form visible

3. **Try login:**
   ```
   Username: admin
   Password: admin123
   ```

4. **Should work:**
   - ✅ Validates credentials
   - ✅ Redirects to school selector
   - ✅ Shows 2 schools
   - ✅ Can access dashboard

---

## 📋 Complete Checklist

### **Step 1: Enable PDO**
- [ ] Login to cPanel
- [ ] Find "Select PHP Version"
- [ ] Check: pdo
- [ ] Check: pdo_mysql
- [ ] Check: mbstring
- [ ] Save changes

### **Step 2: Verify**
- [ ] Create check_pdo.php
- [ ] Visit it - should show enabled
- [ ] Delete check_pdo.php

### **Step 3: Test Site**
- [ ] Visit login page
- [ ] No PDO errors ✅
- [ ] Try login
- [ ] Works! ✅

### **Step 4: Cleanup**
- [ ] Delete any test files
- [ ] Change admin password
- [ ] Ready to use!

---

## 🎊 Summary

**Error:** Class "PDO" not found  
**Cause:** PDO extension not enabled on server  
**Solution:** Enable PDO in cPanel PHP Selector  
**Time:** 2 minutes  
**Result:** Database connections work!  

---

## 📞 Quick Steps

**Fastest Fix (2 minutes):**

1. **cPanel** → Search: "Select PHP Version"
2. **Check boxes:**
   - pdo
   - pdo_mysql
   - mbstring
3. **Save**
4. **Test login** → Should work!

---

**Enable PDO and your site will work perfectly!** 🚀

---

**Document:** FIX_PDO_NOT_FOUND_ERROR.md  
**Date:** October 23, 2025  
**Status:** Ready to Fix  
**Time:** 2 minutes  
**Difficulty:** Easy  

