# 📦 Files to Upload to cPanel - Multi-Tenant System

## ✅ Complete Upload List

---

## 📁 FOLDERS TO UPLOAD (Required)

### **Core Application Folders:**
```
✅ admin/                    (All student management pages)
✅ super_admin/              (Multi-tenant management) ⭐ NEW!
✅ includes/                 (Core functions + school_context.php) ⭐ UPDATED!
✅ images/                   (Logos, assets)
✅ payments/                 (Payment processing)
✅ vendor/                   (Composer dependencies)
```

### **Supporting Folders:**
```
✅ cron/                     (Automated tasks)
✅ api/                      (API endpoints)
✅ database/                 (SQL files only, not PHP scripts)
```

### **Empty Folders (Create on Server):**
```
✅ logs/                     (For error logs) - Create empty, set 755
✅ cache/                    (For caching) - Create empty, set 755
✅ uploads/                  (For file uploads) - Create empty, set 755
✅ backups/                  (For backups) - Create empty, set 755
✅ exports/                  (For exports) - Create empty, set 755
```

---

## 📄 FILES TO UPLOAD (Required)

### **Root Level Files:**
```
✅ config.php                (Edit DB credentials before/after upload)
✅ index.php                 (Student registration)
✅ register.php              (Student registration)
✅ select_school.php         (School selector) ⭐ NEW & BEAUTIFUL!
✅ success.php               (Payment success)
✅ verify-email.php          (Email verification)
✅ payment_selection.php     (Payment page)
✅ .htaccess                 (If exists - for URL rewriting)
```

---

## 🗄️ DATABASE FILE

**Choose ONE:**

### **Option A: With Test Data (Recommended for Initial Testing)**
```
✅ multi_tenant_database.sql
```
**Contains:**
- All tables (36 tables)
- 2 schools (KINE, TEST)
- 10 test students (5 per school)
- 4 sample payments
- All settings

### **Option B: Clean Installation**
```
✅ SKOLO_KINE_COMPLETE_DATABASE.sql
```
**Contains:**
- All tables (36 tables)
- 1 default school (KINE)
- Default admin account
- No student data (fresh start)

---

## ❌ FILES NOT TO UPLOAD

### **Development/Testing Files:**
```
❌ test_*.php                (All test files)
❌ seed_*.php                (Seeder scripts)
❌ quick_test.php            (Local test)
❌ check_*.php               (Check scripts)
❌ generate_*.php            (Generator scripts)
❌ setup_*.php               (Setup scripts)
❌ add_*.php                 (Migration helpers)
```

### **Documentation Files (Optional):**
```
❌ *.md                      (All markdown files)
   Keep locally for reference
   Upload only if you want docs on server
```

### **Local Data:**
```
❌ logs/*                    (Old log files)
❌ cache/*                   (Cached data)
❌ backups/*                 (Local backups)
❌ exports/*                 (Local exports)
```

### **Database Scripts:**
```
❌ database/run_*.php        (Migration PHP scripts)
❌ database/migrate_*.php    (Migration scripts)
   Keep SQL files only:
   ✅ database/create_*.sql
   ✅ database/schema.sql
```

---

## 📦 Quick Upload Method

### **Method 1: ZIP and Upload (Recommended)**

**Create ZIP with only these:**
```
skolokine-upload.zip
├── admin/
├── super_admin/
├── includes/
├── images/
├── payments/
├── vendor/
├── cron/
├── api/
├── config.php
├── index.php
├── register.php
├── select_school.php
├── success.php
├── verify-email.php
└── payment_selection.php
```

**Steps:**
1. Select folders/files above
2. Create ZIP
3. Upload to cPanel
4. Extract
5. Done!

---

### **Method 2: FTP Upload**

**Using FileZilla or similar:**
```
Host: ftp.yourdomain.com
Username: [cPanel username]
Password: [cPanel password]
Port: 21

Upload to: /public_html/skolokine/
```

Drag and drop folders/files listed above.

---

## 🔧 Files to Edit AFTER Upload

### **1. config.php** (REQUIRED)

**Find and update these lines:**

**Line 3-7: Database Configuration**
```php
// BEFORE (localhost):
define('DB_HOST', '127.0.0.1');
define('DB_NAME', 'multi_tenant_skoloi');
define('DB_USER', 'root');
define('DB_PASS', '');

// AFTER (cPanel):
define('DB_HOST', 'localhost');
define('DB_NAME', 'cpanelusername_skolokine_multi');
define('DB_USER', 'cpanelusername_skolokine_admin');
define('DB_PASS', 'YourGeneratedPassword');
```

**Line 57: Public URL**
```php
// BEFORE:
define('PUBLIC_BASE_URL', 'https://kine.melanegroup.com/Skolo-Kine');

// AFTER:
define('PUBLIC_BASE_URL', 'https://yourdomain.com/skolokine');
```

**Line 10-17: SMTP Configuration**
```php
define('SMTP_HOST', 'mail.yourdomain.com');
define('SMTP_USERNAME', 'noreply@yourdomain.com');
define('SMTP_PASSWORD', 'YourEmailPassword');
define('SMTP_FROM_EMAIL', 'noreply@yourdomain.com');
```

**Line 44: Debug Mode**
```php
define('APP_DEBUG', false); // Change from true
```

**Line 40: Error Display**
```php
ini_set('display_errors', 0); // Change from 1
```

---

### **2. .htaccess** (Create if doesn't exist)

Create in root folder with:
```apache
# Protect sensitive files
<Files config.php>
    Order Allow,Deny
    Deny from all
</Files>

# Force HTTPS
RewriteEngine On
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST%}/$1 [R=301,L]

# Prevent directory listing
Options -Indexes

# Protect folders
<DirectoryMatch "database|includes|logs|backups">
    Order Allow,Deny
    Deny from all
</DirectoryMatch>
```

---

## 📊 File Structure on Server

### **After Upload, Your cPanel Should Have:**

```
public_html/
└── skolokine/                      (or root if no subfolder)
    ├── admin/
    │   ├── dashboard.php
    │   ├── create.php
    │   ├── edit.php
    │   ├── delete.php
    │   ├── login.php
    │   ├── logout.php
    │   ├── payments.php
    │   ├── partials/
    │   │   ├── header.php          ⭐ UPDATED (smart links)
    │   │   └── footer.php
    │   └── settings/               ⭐ NEW!
    │       └── school_settings.php  (Modern interface)
    │
    ├── super_admin/                ⭐ NEW!
    │   ├── dashboard.php
    │   └── schools/
    │       ├── create.php
    │       ├── list.php
    │       ├── view.php
    │       └── edit.php
    │
    ├── includes/
    │   ├── functions.php           ⭐ UPDATED
    │   ├── school_context.php      ⭐ NEW!
    │   ├── email_functions.php
    │   ├── wallet_functions.php
    │   └── [other includes]
    │
    ├── images/
    │   └── img-melanesys-logo.svg
    │
    ├── payments/
    │   └── mtn/
    │
    ├── vendor/                     (Composer packages)
    │
    ├── config.php                  ⭐ EDIT THIS!
    ├── index.php
    ├── register.php
    ├── select_school.php           ⭐ NEW & BEAUTIFUL!
    ├── success.php
    ├── verify-email.php
    ├── .htaccess                   ⭐ CREATE THIS!
    │
    └── [Create these empty folders with 755]:
        ├── logs/
        ├── cache/
        ├── uploads/
        ├── backups/
        └── exports/
```

---

## 🎯 Size Expectations

**Total Upload Size:** ~5-15 MB (depending on vendor folder)

**Individual Folder Sizes:**
- admin/ → ~500 KB
- super_admin/ → ~100 KB
- includes/ → ~200 KB
- vendor/ → ~3-10 MB (Composer packages)
- images/ → ~50 KB
- payments/ → ~50 KB
- Rest → ~50 KB each

---

## ⚡ Quick Upload Checklist

### **Minimum Required for System to Work:**

**Must Have:**
- [ ] admin/ folder
- [ ] includes/ folder
- [ ] images/ folder
- [ ] vendor/ folder (for PHPMailer, etc.)
- [ ] config.php (edited)
- [ ] index.php
- [ ] select_school.php

**Multi-Tenant Specific:**
- [ ] super_admin/ folder ⭐
- [ ] includes/school_context.php ⭐
- [ ] admin/settings/ folder ⭐

**Nice to Have:**
- [ ] cron/ folder (for automation)
- [ ] payments/ folder (if using payments)
- [ ] api/ folder (if using API)

---

## 🔍 Verification Commands

**After upload, test these URLs:**

```
https://yourdomain.com/skolokine/
https://yourdomain.com/skolokine/admin/login.php
https://yourdomain.com/skolokine/select_school.php
https://yourdomain.com/skolokine/super_admin/dashboard.php
```

**All should load without 404 errors!**

---

## 📝 Pro Tips

### **Tip 1: Use cPanel File Manager**
- Easier than FTP
- Direct file editing
- Built-in text editor
- Extract ZIP directly

### **Tip 2: Compress Vendor Folder Separately**
- vendor/ is large
- ZIP it separately
- Upload and extract on server
- Saves upload time

### **Tip 3: Test Connection First**
- Upload only config.php first
- Test database connection
- Then upload everything else
- Catches DB issues early

### **Tip 4: Keep a Backup ZIP**
- Keep your upload ZIP file
- Easy to re-deploy if needed
- Quick rollback option

### **Tip 5: Incremental Upload**
- Upload folders one by one
- Test after each upload
- Easier to find issues

---

## ✅ Final Upload Checklist

Before clicking "I'm done":

- [ ] All required folders uploaded
- [ ] config.php edited with correct credentials
- [ ] Database imported successfully
- [ ] Login tested and works
- [ ] School selector loads
- [ ] Dashboard shows students
- [ ] Navigation links work
- [ ] Settings page loads
- [ ] Can switch schools
- [ ] Favicon appears
- [ ] No 404 errors
- [ ] No PHP errors
- [ ] HTTPS works

---

## 🎊 Ready to Upload!

### **Your Upload Package Includes:**
- ✅ 24 new files (multi-tenant system)
- ✅ 11 updated files
- ✅ Complete database schema
- ✅ 10 test students
- ✅ Modern interfaces
- ✅ Working navigation
- ✅ Production-ready code

### **Total File Count:** ~200-300 files
### **Total Size:** ~5-15 MB
### **Upload Time:** 5-15 minutes (depending on connection)

---

**Let's deploy your multi-tenant empire to the cloud!** ☁️

🚀 **Start with: CPANEL_DEPLOYMENT_GUIDE_MULTI_TENANT.md** 🚀

