# 🚀 Deploy Storage Dashboards to cPanel

## ⚠️ **Problem**: 404 Error on Live Server

**Cause:** Files exist on your local machine but NOT on the live server (test.melanegroup.com)

**Solution:** Upload the files to cPanel

---

## 📦 Files to Upload

### **1. Super Admin Storage Dashboard**

Upload this folder and file to cPanel:

```
super_admin/
  └── storage/
      └── overview.php
```

**cPanel Path:**
```
/public_html/test.melanegroup.com/Multi-Tanent/super_admin/storage/overview.php
```

---

### **2. Tenant Admin Storage Dashboard**

Upload this folder and file:

```
admin/
  └── storage/
      └── usage.php
```

**cPanel Path:**
```
/public_html/test.melanegroup.com/Multi-Tanent/admin/storage/usage.php
```

---

### **3. API Endpoints**

Upload these API files:

```
api/
  └── storage/
      ├── tenant.php
      ├── usage.php
      └── file.php
```

**cPanel Path:**
```
/public_html/test.melanegroup.com/Multi-Tanent/api/storage/
```

---

### **4. Updated Navigation Files**

These files were modified to add "Storage" links:

```
super_admin/dashboard.php
admin/dashboard.php
admin/partials/header.php
```

**Upload to:**
```
/public_html/test.melanegroup.com/Multi-Tanent/super_admin/dashboard.php
/public_html/test.melanegroup.com/Multi-Tanent/admin/dashboard.php
/public_html/test.melanegroup.com/Multi-Tanent/admin/partials/header.php
```

---

## 📋 Step-by-Step Upload Instructions

### **Method 1: Using cPanel File Manager (Recommended)**

1. **Login to cPanel**
   - Go to your hosting control panel
   - Login with your credentials

2. **Open File Manager**
   - Click "File Manager" icon
   - Navigate to: `public_html/test.melanegroup.com/Multi-Tanent/`

3. **Create Directories First**

   **For Super Admin:**
   - Navigate to `super_admin/`
   - Click "New Folder"
   - Create folder named: `storage`
   
   **For Admin:**
   - Navigate to `admin/`
   - Click "New Folder" (if not exists)
   - Create folder named: `storage`
   
   **For API:**
   - Navigate to `api/`
   - Click "New Folder" (if not exists)
   - Create folder named: `storage`

4. **Upload Files**
   
   **Upload super_admin/storage/overview.php:**
   - Navigate to `super_admin/storage/`
   - Click "Upload"
   - Select `overview.php` from your local: `C:\xampp\htdocs\Multi-Tanent\super_admin\storage\overview.php`
   - Upload
   
   **Upload admin/storage/usage.php:**
   - Navigate to `admin/storage/`
   - Click "Upload"
   - Select `usage.php` from your local: `C:\xampp\htdocs\Multi-Tanent\admin\storage\usage.php`
   - Upload
   
   **Upload API files:**
   - Navigate to `api/storage/`
   - Click "Upload"
   - Select all 3 files from: `C:\xampp\htdocs\Multi-Tanent\api\storage\`
     - `tenant.php`
     - `usage.php`
     - `file.php`
   - Upload

5. **Update Modified Files**
   
   - Upload `super_admin/dashboard.php` (overwrites existing)
   - Upload `admin/dashboard.php` (overwrites existing)
   - Upload `admin/partials/header.php` (overwrites existing)

6. **Set Permissions**
   - Select the uploaded `.php` files
   - Click "Permissions"
   - Set to: `644` (read/write for owner, read for others)
   - Click "Change Permissions"

---

### **Method 2: Using FTP (FileZilla)**

1. **Connect to FTP**
   - Host: `ftp.melanegroup.com` (or your FTP host)
   - Username: Your cPanel username
   - Password: Your cPanel password
   - Port: 21

2. **Navigate to Directory**
   - Remote: `/public_html/test.melanegroup.com/Multi-Tanent/`
   - Local: `C:\xampp\htdocs\Multi-Tanent\`

3. **Create Folders (if not exist)**
   - Right-click in remote panel
   - Create Directory: `super_admin/storage`
   - Create Directory: `admin/storage`
   - Create Directory: `api/storage`

4. **Upload Files**
   - Drag and drop from local to remote:
     - `super_admin/storage/overview.php`
     - `admin/storage/usage.php`
     - `api/storage/tenant.php`
     - `api/storage/usage.php`
     - `api/storage/file.php`
     - `super_admin/dashboard.php` (overwrite)
     - `admin/dashboard.php` (overwrite)
     - `admin/partials/header.php` (overwrite)

---

### **Method 3: Upload ZIP via cPanel (Fastest)**

1. **Create ZIP on Local Machine**
   
   **Windows Command (PowerShell):**
   ```powershell
   cd C:\xampp\htdocs\Multi-Tanent
   Compress-Archive -Path super_admin\storage, admin\storage, api\storage, super_admin\dashboard.php, admin\dashboard.php, admin\partials\header.php -DestinationPath storage_dashboards.zip -Force
   ```

2. **Upload ZIP to cPanel**
   - Login to cPanel File Manager
   - Navigate to: `public_html/test.melanegroup.com/Multi-Tanent/`
   - Click "Upload"
   - Upload `storage_dashboards.zip`
   - Right-click ZIP file → "Extract"
   - Delete ZIP after extraction

---

## ✅ Verification After Upload

### **1. Check Files Exist**

Access these URLs directly to see if files exist:

```
https://test.melanegroup.com/Multi-Tanent/super_admin/storage/overview.php
https://test.melanegroup.com/Multi-Tanent/admin/storage/usage.php
https://test.melanegroup.com/Multi-Tanent/api/storage/tenant.php
```

**Expected:**
- If files exist but you're not logged in: You'll be redirected to login
- If files don't exist: 404 error (upload again)

---

### **2. Check Permissions**

In cPanel File Manager, verify permissions:

```
super_admin/storage/overview.php  → 644
admin/storage/usage.php           → 644
api/storage/*.php                 → 644
```

---

### **3. Test Functionality**

1. **Login as Super Admin**
   ```
   https://test.melanegroup.com/Multi-Tanent/admin/login.php
   ```

2. **Go to Dashboard**
   - You should see "Storage" link in navigation
   - Click it
   - Should load storage overview (not 404)

3. **Login as School Admin**
   - Select a school
   - Click "Storage" link
   - Should load storage usage (not 404)

---

## 🔍 Troubleshooting

### **Still Getting 404?**

**Check 1: File Actually Uploaded?**
```
In cPanel File Manager, navigate to:
/public_html/test.melanegroup.com/Multi-Tanent/super_admin/storage/

Do you see overview.php?
- YES → Good, proceed to Check 2
- NO → Upload the file again
```

**Check 2: Correct Path?**
```
URL: https://test.melanegroup.com/Multi-Tanent/super_admin/storage/overview.php
File: /public_html/test.melanegroup.com/Multi-Tanent/super_admin/storage/overview.php

Paths must match exactly (case-sensitive on Linux servers)
```

**Check 3: .htaccess Blocking?**
```
Check if there's a .htaccess file blocking access:
- Navigate to super_admin/ folder
- Check for .htaccess
- If exists, ensure it doesn't block storage/
```

**Check 4: PHP Syntax Error?**
```
View the file in cPanel's Code Editor
Look for any red syntax errors
```

---

## 🎯 Quick Upload Checklist

- [ ] Created `super_admin/storage/` folder on server
- [ ] Uploaded `super_admin/storage/overview.php`
- [ ] Created `admin/storage/` folder on server
- [ ] Uploaded `admin/storage/usage.php`
- [ ] Created `api/storage/` folder on server
- [ ] Uploaded `api/storage/tenant.php`
- [ ] Uploaded `api/storage/usage.php`
- [ ] Uploaded `api/storage/file.php`
- [ ] Updated `super_admin/dashboard.php`
- [ ] Updated `admin/dashboard.php`
- [ ] Updated `admin/partials/header.php`
- [ ] Set permissions to 644 for all PHP files
- [ ] Tested: Super admin storage page loads
- [ ] Tested: Tenant admin storage page loads
- [ ] Tested: Charts render correctly
- [ ] Tested: Delete button works

---

## 📸 Expected File Structure on Server

```
/public_html/test.melanegroup.com/Multi-Tanent/
│
├── super_admin/
│   ├── dashboard.php ← UPDATED
│   ├── storage/
│   │   └── overview.php ← NEW
│   └── ...
│
├── admin/
│   ├── dashboard.php ← UPDATED
│   ├── storage/
│   │   └── usage.php ← NEW
│   ├── partials/
│   │   └── header.php ← UPDATED
│   └── ...
│
└── api/
    └── storage/ ← NEW FOLDER
        ├── tenant.php ← NEW
        ├── usage.php ← NEW
        └── file.php ← NEW
```

---

## 🚀 After Successful Upload

Test these URLs:

1. **Super Admin:**
   ```
   https://test.melanegroup.com/Multi-Tanent/super_admin/storage/overview.php
   ```

2. **Tenant Admin:**
   ```
   https://test.melanegroup.com/Multi-Tanent/admin/storage/usage.php
   ```

3. **API Test:**
   ```
   https://test.melanegroup.com/Multi-Tanent/api/storage/tenant.php?tenant_id=YOUR_TENANT_ID
   ```

All should work without 404 errors! ✅

---

## 💡 Pro Tip

**For future uploads**, keep your local and live server in sync using:
- Git deployment
- Automatic FTP sync tools
- Or manual sync checklist (like this one)

---

**Ready to upload?** Follow the steps above and the 404 error will be resolved! 🎉

