# 📚 Clean URLs Quick Reference

Quick reference guide for the clean URLs implementation.

---

## 🔗 URL Patterns

### Tenant Isolation URLs

| Clean URL | Rewrites To |
|-----------|-------------|
| `/kine/register` | `register_student.php?school=kine` |
| `/kine/parent/register` | `parent_register.php?school=kine` |
| `/kine/parent/login` | `parent_login.php?school=kine` |
| `/kine/login` | `student_login.php?school=kine` |
| `/kine/info` | `index.php?school=kine` |
| `/school/kine/admin/dashboard` | `admin/dashboard.php?school=kine` |
| `/school/kine/super_admin/dashboard` | `super_admin/dashboard.php?school=kine` |

### Clean URLs (Remove .php)

| Clean URL | Actual File |
|-----------|-------------|
| `/admin/dashboard` | `admin/dashboard.php` |
| `/admin/students/list` | `admin/students/list.php` |
| `/admin/login` | `admin/login.php` |
| `/super_admin/dashboard` | `super_admin/dashboard.php` |
| `/super_admin/schools/list` | `super_admin/schools/list.php` |
| `/parent/dashboard` | `parent/dashboard.php` |
| `/student/dashboard` | `student/dashboard.php` |

---

## 🔒 Protected Directories

These directories are protected from direct web access:

- ✅ `includes/` - PHP includes only
- ✅ `vendor/` - Composer dependencies
- ✅ `database/` - SQL files
- ✅ `logs/` - Log files
- ✅ `uploads/` - Uploads (PHP execution blocked)

---

## 🛡️ Protected File Types

These file types are blocked:

- `.sql` - Database dumps
- `.log` - Log files
- `.bak`, `.backup` - Backup files
- `.ini` - Configuration files
- `.env` - Environment files
- `.htaccess`, `.htpasswd` - Apache configs

---

## ⚙️ Configuration

### Enable HTTPS Enforcement

Edit `.htaccess` and uncomment:
```apache
RewriteCond %{HTTPS} off
RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

### Change RewriteBase

If installed in a different path, update:
```apache
RewriteBase /your-install-path/
```

---

## 🧪 Testing

### Quick Test URLs

**Working URLs (should return 200):**
- `https://your-domain.com/Multi-Tanent/admin/dashboard`
- `https://your-domain.com/Multi-Tanent/kine/register`

**Blocked URLs (should return 403):**
- `https://your-domain.com/Multi-Tanent/config.php`
- `https://your-domain.com/Multi-Tanent/includes/functions.php`
- `https://your-domain.com/Multi-Tanent/vendor/autoload.php`

### Automated Test Suite

Run: `https://your-domain.com/Multi-Tanent/tools/test_clean_urls_comprehensive.php`

---

## 📁 File Structure

```
Multi-Tanent/
├── .htaccess                    # Main rewrite rules
├── includes/
│   └── .htaccess               # Protect includes
├── vendor/
│   └── .htaccess               # Protect vendor
├── uploads/
│   └── .htaccess               # Block PHP in uploads
├── database/
│   └── .htaccess               # Protect database files
├── logs/
│   └── .htaccess               # Protect log files
└── tools/
    └── test_clean_urls_comprehensive.php  # Test suite
```

---

## 🐛 Common Issues

| Issue | Solution |
|-------|----------|
| 404 errors | Enable mod_rewrite, check AllowOverride |
| Protected files accessible | Verify .htaccess files exist |
| PHP executes in uploads | Check uploads/.htaccess |
| Infinite redirect | Check for conflicting rules |

---

## 📞 Quick Commands

```bash
# Enable mod_rewrite
sudo a2enmod rewrite

# Restart Apache
sudo systemctl restart apache2

# Check Apache modules
apache2ctl -M | grep rewrite

# View error logs
tail -f /var/log/apache2/error.log
```

---

**Last Updated:** 2025-01-16

